/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gradle.gitversioning;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.qoomon.gitversioning.commons.GitRefType;
import org.gradle.api.Action;
import org.gradle.util.ConfigureUtil;

public class GitVersioningPluginConfig {
    private static final Pattern MATCH_ALL = Pattern.compile(".*");
    public Boolean disable = false;
    public Pattern describeTagPattern = MATCH_ALL;
    public Boolean updateGradleProperties;
    public RefPatchDescriptionList refs = new RefPatchDescriptionList();
    public PatchDescription rev;

    public void refs(Closure<RefPatchDescriptionList> closure) {
        this.refs = (RefPatchDescriptionList)ConfigureUtil.configure(closure, (Object)new RefPatchDescriptionList());
    }

    public void rev(Closure<PatchDescription> closure) {
        this.rev = (PatchDescription)ConfigureUtil.configure(closure, (Object)new PatchDescription());
    }

    public void refs(Action<RefPatchDescriptionList> action) {
        this.refs = new RefPatchDescriptionList();
        action.execute((Object)this.refs);
    }

    public void rev(Action<PatchDescription> action) {
        this.rev = new PatchDescription();
        action.execute((Object)this.rev);
    }

    public static class RefPatchDescriptionList {
        public boolean considerTagsOnBranches = false;
        public List<RefPatchDescription> list = new ArrayList<RefPatchDescription>();

        public void branch(String pattern, Closure<RefPatchDescription> closure) {
            this.list.add((RefPatchDescription)ConfigureUtil.configure(closure, (Object)new RefPatchDescription(GitRefType.BRANCH, Pattern.compile(pattern))));
        }

        public void tag(String pattern, Closure<RefPatchDescription> closure) {
            this.list.add((RefPatchDescription)ConfigureUtil.configure(closure, (Object)new RefPatchDescription(GitRefType.TAG, Pattern.compile(pattern))));
        }

        public void branch(String pattern, Action<RefPatchDescription> action) {
            RefPatchDescription ref = new RefPatchDescription(GitRefType.BRANCH, Pattern.compile(pattern));
            this.list.add(ref);
            action.execute((Object)ref);
        }

        public void tag(String pattern, Action<RefPatchDescription> action) {
            RefPatchDescription ref = new RefPatchDescription(GitRefType.TAG, Pattern.compile(pattern));
            this.list.add(ref);
            action.execute((Object)ref);
        }
    }

    public static class PatchDescription {
        public Pattern describeTagPattern;
        public Boolean updateGradleProperties;
        public String version;
        public Map<String, String> properties = new HashMap<String, String>();
    }

    public static class RefPatchDescription
    extends PatchDescription {
        public final GitRefType type;
        public final Pattern pattern;

        public RefPatchDescription(GitRefType type, Pattern pattern) {
            this.type = type;
            this.pattern = pattern;
        }

        public RefPatchDescription(GitRefType type, Pattern pattern, PatchDescription description) {
            this(type, pattern);
            this.describeTagPattern = description.describeTagPattern;
            this.updateGradleProperties = description.updateGradleProperties;
            this.version = description.version;
            this.properties = new HashMap<String, String>(description.properties);
        }
    }
}

