/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.io.IOException;
import java.util.Comparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class RefNameComparator
implements Comparator<Ref> {
    private final Repository repository;

    public RefNameComparator(Repository repository) {
        this.repository = repository;
    }

    @Override
    public int compare(Ref ref1, Ref ref2) {
        ObjectId ref1PeeledObjectId = ref1.getPeeledObjectId();
        ObjectId ref2PeeledObjectId = ref2.getPeeledObjectId();
        if (ref1PeeledObjectId != null && ref2PeeledObjectId != null) {
            try {
                int ref1CommitTime = this.repository.parseCommit((AnyObjectId)ref1.getObjectId()).getCommitTime();
                int ref2CommitTime = this.repository.parseCommit((AnyObjectId)ref2.getObjectId()).getCommitTime();
                return Integer.compare(ref1CommitTime, ref2CommitTime);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (ref1PeeledObjectId != null) {
            return -1;
        }
        if (ref2PeeledObjectId != null) {
            return 1;
        }
        return ref1.getName().compareTo(ref2.getName());
    }
}

