/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gradle.gitversioning;

import groovy.lang.Closure;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.qoomon.gitversioning.commons.GitRefType;
import me.qoomon.gitversioning.commons.GitSituation;
import me.qoomon.gitversioning.commons.GitUtil;
import me.qoomon.gitversioning.commons.StringUtil;
import me.qoomon.gradle.gitversioning.GitVersionDetails;
import me.qoomon.gradle.gitversioning.GitVersioningPluginConfig;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.util.ConfigureUtil;

public class GitVersioningPluginExtension {
    private static final String OPTION_NAME_GIT_TAG = "git.tag";
    private static final String OPTION_NAME_GIT_BRANCH = "git.branch";
    private static final String OPTION_NAME_DISABLE = "versioning.disable";
    private static final String OPTION_PREFER_TAGS = "versioning.preferTags";
    private static final String OPTION_UPDATE_GRADLE_PROPERTIES = "versioning.updateGradleProperties";
    private static final String DEFAULT_BRANCH_VERSION_FORMAT = "${branch}-SNAPSHOT";
    private static final String DEFAULT_TAG_VERSION_FORMAT = "${tag}";
    private static final String DEFAULT_COMMIT_VERSION_FORMAT = "${commit}";
    public final Project rootProject;
    public final Logger logger;
    public GitVersionDetails gitVersionDetails;
    public Map<String, GitVersioningPluginConfig.PropertyDescription> gitVersioningPropertyDescriptionMap;
    public Map<String, String> globalFormatPlaceholderMap;
    public Map<String, String> gitProjectProperties;

    public GitVersioningPluginExtension(Project project) {
        this.rootProject = project;
        this.logger = this.rootProject.getLogger();
    }

    public void apply(Closure<?> closure) throws IOException {
        GitVersioningPluginConfig config = new GitVersioningPluginConfig();
        ConfigureUtil.configure(closure, (Object)config);
        this.apply(config);
    }

    public void apply(GitVersioningPluginConfig config) throws IOException {
        GitSituation gitSituation;
        this.setDefaults(config);
        String commandOptionDisable = this.getCommandOption(OPTION_NAME_DISABLE);
        if (commandOptionDisable != null) {
            boolean disabled = Boolean.parseBoolean(commandOptionDisable);
            if (disabled) {
                this.logger.info("skip - versioning is disabled by command option");
                return;
            }
        } else if (config.disable) {
            this.logger.info("skip - versioning is disabled by config option");
            return;
        }
        if ((gitSituation = this.getGitSituation(this.rootProject.getProjectDir())) == null) {
            this.logger.warn("skip - project is not part of a git repository");
            return;
        }
        this.logger.debug("git situation: " + gitSituation.getRootDirectory());
        this.logger.debug("  root directory: " + gitSituation.getRootDirectory());
        this.logger.debug("  head commit: " + gitSituation.getHeadCommit());
        this.logger.debug("  head commit timestamp: " + gitSituation.getHeadCommitTimestamp());
        this.logger.debug("  head branch: " + gitSituation.getHeadBranch());
        this.logger.debug("  head tags: " + gitSituation.getHeadTags());
        boolean preferTagsOption = this.getPreferTagsOption(config);
        this.logger.debug("option - prefer tags: " + preferTagsOption);
        this.gitVersionDetails = GitVersioningPluginExtension.getGitVersionDetails(gitSituation, config, preferTagsOption);
        this.logger.info("git " + this.gitVersionDetails.getRefType().name().toLowerCase() + ": " + this.gitVersionDetails.getRefName());
        this.gitVersioningPropertyDescriptionMap = this.gitVersionDetails.getConfig().properties.stream().collect(Collectors.toMap(property -> property.name, property -> property));
        this.globalFormatPlaceholderMap = GitVersioningPluginExtension.generateGlobalFormatPlaceholderMap(gitSituation, this.gitVersionDetails, this.rootProject);
        this.gitProjectProperties = GitVersioningPluginExtension.generateGitProjectProperties(gitSituation, this.gitVersionDetails);
        boolean updateGradlePropertiesFileOption = this.getUpdateGradlePropertiesFileOption(config, this.gitVersionDetails.getConfig());
        this.logger.debug("option - update gradle.properties file: " + updateGradlePropertiesFileOption);
        this.rootProject.getAllprojects().forEach(project -> {
            File gradleProperties;
            String originalProjectVersion = project.getVersion().toString();
            this.updateVersion((Project)project);
            this.updatePropertyValues((Project)project, originalProjectVersion);
            this.addGitProperties((Project)project);
            if (updateGradlePropertiesFileOption && (gradleProperties = project.file((Object)"gradle.properties")).exists()) {
                this.updateGradlePropertiesFile(gradleProperties, (Project)project);
            }
        });
    }

    private void updateVersion(Project project) {
        String gitProjectVersion = this.getGitVersion(project.getVersion().toString());
        project.getLogger().info("update version: " + gitProjectVersion);
        project.setVersion((Object)gitProjectVersion);
    }

    private void updatePropertyValues(Project project, String originalProjectVersion) {
        project.getProperties().forEach((key, value) -> {
            String gitPropertyValue;
            if (value instanceof String && !(gitPropertyValue = this.getGitProjectPropertyValue((String)key, (String)value, originalProjectVersion)).equals(value)) {
                project.getLogger().info("update property " + key + ": " + gitPropertyValue);
                project.setProperty(key, (Object)gitPropertyValue);
            }
        });
    }

    private void addGitProperties(Project project) {
        ExtraPropertiesExtension extraProperties = project.getExtensions().getExtraProperties();
        this.gitProjectProperties.forEach((arg_0, arg_1) -> ((ExtraPropertiesExtension)extraProperties).set(arg_0, arg_1));
    }

    private void updateGradlePropertiesFile(File gradleProperties, Project project) {
        PropertiesConfiguration gradlePropertiesConfig = new PropertiesConfiguration();
        try (FileReader reader = new FileReader(gradleProperties);){
            gradlePropertiesConfig.read((Reader)reader);
        }
        catch (IOException | ConfigurationException e) {
            throw new RuntimeException(e);
        }
        if (gradlePropertiesConfig.containsKey("version")) {
            Object gradlePropertyVersion = gradlePropertiesConfig.getProperty("version");
            Object projectVersion = project.getVersion();
            if (!Objects.equals(projectVersion, gradlePropertyVersion)) {
                gradlePropertiesConfig.setProperty("version", projectVersion);
            }
        }
        Map projectProperties = project.getProperties();
        this.gitVersionDetails.getConfig().properties.forEach(property -> {
            String propertyName = property.name;
            if (gradlePropertiesConfig.containsKey(propertyName)) {
                Object gradlePropertyValue = gradlePropertiesConfig.getProperty(propertyName);
                Object projectPropertyValue = projectProperties.get(propertyName);
                if (!Objects.equals(projectPropertyValue, gradlePropertyValue)) {
                    gradlePropertiesConfig.setProperty(propertyName, projectPropertyValue);
                }
            }
        });
        try (FileWriter writer = new FileWriter(gradleProperties);){
            gradlePropertiesConfig.write((Writer)writer);
        }
        catch (IOException | ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private GitSituation getGitSituation(File executionRootDirectory) throws IOException {
        String providedBranch;
        GitSituation gitSituation = GitUtil.situation(executionRootDirectory);
        if (gitSituation == null) {
            return null;
        }
        String providedTag = this.getCommandOption(OPTION_NAME_GIT_TAG);
        if (providedTag != null) {
            this.logger.debug("set git head tag by command option: " + providedTag);
            gitSituation = GitSituation.Builder.of(gitSituation).setHeadBranch(null).setHeadTags(providedTag.isEmpty() ? Collections.emptyList() : Collections.singletonList(providedTag)).build();
        }
        if ((providedBranch = this.getCommandOption(OPTION_NAME_GIT_BRANCH)) != null) {
            this.logger.debug("set git head branch by command option: " + providedBranch);
            gitSituation = GitSituation.Builder.of(gitSituation).setHeadBranch(providedBranch).build();
        }
        return gitSituation;
    }

    private static GitVersionDetails getGitVersionDetails(GitSituation gitSituation, GitVersioningPluginConfig config, boolean preferTags) {
        String headCommit = gitSituation.getHeadCommit();
        if (!gitSituation.getHeadTags().isEmpty() && (gitSituation.isDetached() || preferTags)) {
            List sortedHeadTags = gitSituation.getHeadTags().stream().sorted(Comparator.comparing(DefaultArtifactVersion::new)).collect(Collectors.toList());
            for (GitVersioningPluginConfig.VersionDescription tagConfig : config.tags) {
                for (String headTag : sortedHeadTags) {
                    if (tagConfig.pattern != null && !headTag.matches(tagConfig.pattern)) continue;
                    return new GitVersionDetails(headCommit, GitRefType.TAG, headTag, tagConfig);
                }
            }
        }
        if (gitSituation.isDetached()) {
            if (config.commit != null && (config.commit.pattern == null || headCommit.matches(config.commit.pattern))) {
                return new GitVersionDetails(headCommit, GitRefType.COMMIT, headCommit, config.commit);
            }
            return new GitVersionDetails(headCommit, GitRefType.COMMIT, headCommit, new GitVersioningPluginConfig.VersionDescription(){
                {
                    this.versionFormat = GitVersioningPluginExtension.DEFAULT_COMMIT_VERSION_FORMAT;
                }
            });
        }
        String headBranch = gitSituation.getHeadBranch();
        for (GitVersioningPluginConfig.VersionDescription branchConfig : config.branches) {
            if (branchConfig.pattern != null && !headBranch.matches(branchConfig.pattern)) continue;
            return new GitVersionDetails(headCommit, GitRefType.BRANCH, headBranch, branchConfig);
        }
        return new GitVersionDetails(headCommit, GitRefType.BRANCH, headBranch, new GitVersioningPluginConfig.VersionDescription(){
            {
                this.versionFormat = GitVersioningPluginExtension.DEFAULT_BRANCH_VERSION_FORMAT;
            }
        });
    }

    private String getGitVersion(String originalProjectVersion) {
        Map<String, String> placeholderMap = this.generateFormatPlaceholderMap(originalProjectVersion);
        return StringUtil.substituteText(this.gitVersionDetails.getConfig().versionFormat, placeholderMap).replace("/", "-");
    }

    private String getGitProjectPropertyValue(String key, String originalValue, String originalProjectVersion) {
        GitVersioningPluginConfig.PropertyDescription propertyConfig = this.gitVersioningPropertyDescriptionMap.get(key);
        if (propertyConfig == null) {
            return originalValue;
        }
        Map<String, String> placeholderMap = this.generateFormatPlaceholderMap(originalProjectVersion);
        placeholderMap.put("value", originalValue);
        return StringUtil.substituteText(propertyConfig.valueFormat, placeholderMap);
    }

    private Map<String, String> generateFormatPlaceholderMap(String originalProjectVersion) {
        HashMap<String, String> placeholderMap = new HashMap<String, String>();
        placeholderMap.putAll(this.globalFormatPlaceholderMap);
        placeholderMap.putAll(GitVersioningPluginExtension.generateFormatPlaceholderMapFromVersion(originalProjectVersion));
        return placeholderMap;
    }

    private static Map<String, String> generateGlobalFormatPlaceholderMap(GitSituation gitSituation, GitVersionDetails gitVersionDetails, Project rootProject) {
        HashMap<String, String> placeholderMap = new HashMap<String, String>();
        String headCommit = gitSituation.getHeadCommit();
        placeholderMap.put("commit", headCommit);
        placeholderMap.put("commit.short", headCommit.substring(0, 7));
        ZonedDateTime headCommitDateTime = gitSituation.getHeadCommitDateTime();
        placeholderMap.put("commit.timestamp", String.valueOf(headCommitDateTime.toEpochSecond()));
        placeholderMap.put("commit.timestamp.year", String.valueOf(headCommitDateTime.getYear()));
        placeholderMap.put("commit.timestamp.month", StringUtils.leftPad((String)String.valueOf(headCommitDateTime.getMonthValue()), (int)2, (String)"0"));
        placeholderMap.put("commit.timestamp.day", StringUtils.leftPad((String)String.valueOf(headCommitDateTime.getDayOfMonth()), (int)2, (String)"0"));
        placeholderMap.put("commit.timestamp.hour", StringUtils.leftPad((String)String.valueOf(headCommitDateTime.getHour()), (int)2, (String)"0"));
        placeholderMap.put("commit.timestamp.minute", StringUtils.leftPad((String)String.valueOf(headCommitDateTime.getMinute()), (int)2, (String)"0"));
        placeholderMap.put("commit.timestamp.second", StringUtils.leftPad((String)String.valueOf(headCommitDateTime.getSecond()), (int)2, (String)"0"));
        placeholderMap.put("commit.timestamp.datetime", headCommitDateTime.toEpochSecond() > 0L ? headCommitDateTime.format(DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss")) : "00000000.000000");
        String refTypeName = gitVersionDetails.getRefType().name().toLowerCase();
        String refName = gitVersionDetails.getRefName();
        String refNameSlug = GitVersioningPluginExtension.slugify(refName);
        placeholderMap.put("ref", refName);
        placeholderMap.put("ref.slug", refNameSlug);
        placeholderMap.put(refTypeName, refName);
        placeholderMap.put(refTypeName + ".slug", refNameSlug);
        String refPattern = gitVersionDetails.getConfig().pattern;
        if (refPattern != null) {
            Map<String, String> refNameValueGroupMap = StringUtil.valueGroupMap(refName, refPattern);
            placeholderMap.putAll(refNameValueGroupMap);
            placeholderMap.putAll(refNameValueGroupMap.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey() + ".slug", entry -> GitVersioningPluginExtension.slugify((String)entry.getValue()))));
        }
        placeholderMap.put("dirty", !gitSituation.isClean() ? "-DIRTY" : "");
        placeholderMap.put("dirty.snapshot", !gitSituation.isClean() ? "-SNAPSHOT" : "");
        rootProject.getProperties().forEach((key, value) -> {
            if (value instanceof String) {
                placeholderMap.put((String)key, (String)value);
            }
        });
        System.getenv().forEach((key, value) -> placeholderMap.put("env." + key, (String)value));
        return placeholderMap;
    }

    private static Map<String, String> generateFormatPlaceholderMapFromVersion(String originalProjectVersion) {
        HashMap<String, String> placeholderMap = new HashMap<String, String>();
        placeholderMap.put("version", originalProjectVersion);
        placeholderMap.put("version.release", originalProjectVersion.replaceFirst("-SNAPSHOT$", ""));
        return placeholderMap;
    }

    private static Map<String, String> generateGitProjectProperties(GitSituation gitSituation, GitVersionDetails gitVersionDetails) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("git.commit", gitVersionDetails.getCommit());
        ZonedDateTime headCommitDateTime = gitSituation.getHeadCommitDateTime();
        properties.put("git.commit.timestamp", String.valueOf(headCommitDateTime.toEpochSecond()));
        properties.put("git.commit.timestamp.datetime", headCommitDateTime.toEpochSecond() > 0L ? headCommitDateTime.format(DateTimeFormatter.ISO_INSTANT) : "0000-00-00T00:00:00Z");
        String refTypeName = gitVersionDetails.getRefType().name().toLowerCase();
        String refName = gitVersionDetails.getRefName();
        String refNameSlug = GitVersioningPluginExtension.slugify(refName);
        properties.put("git.ref", refName);
        properties.put("git.ref.slug", refNameSlug);
        properties.put("git." + refTypeName, refName);
        properties.put("git." + refTypeName + ".slug", refNameSlug);
        properties.put("git.dirty", Boolean.toString(!gitSituation.isClean()));
        return properties;
    }

    private void setDefaults(GitVersioningPluginConfig config) {
        for (GitVersioningPluginConfig.VersionDescription versionDescription : config.branches) {
            if (versionDescription.versionFormat != null) continue;
            versionDescription.versionFormat = DEFAULT_BRANCH_VERSION_FORMAT;
        }
        for (GitVersioningPluginConfig.VersionDescription versionDescription : config.tags) {
            if (versionDescription.versionFormat != null) continue;
            versionDescription.versionFormat = DEFAULT_TAG_VERSION_FORMAT;
        }
        if (config.commit != null && config.commit.versionFormat == null) {
            config.commit.versionFormat = DEFAULT_COMMIT_VERSION_FORMAT;
        }
    }

    private String getCommandOption(String name) {
        String value = (String)this.rootProject.getProperties().get(name);
        if (value == null) {
            String plainName = name.replaceFirst("^versioning\\.", "");
            String environmentVariableName = "VERSIONING_" + String.join((CharSequence)"_", plainName.split("(?=\\p{Lu})")).replaceAll("\\.", "_").toUpperCase();
            value = System.getenv(environmentVariableName);
        }
        if (value == null) {
            value = System.getProperty(name);
        }
        return value;
    }

    private boolean getPreferTagsOption(GitVersioningPluginConfig config) {
        String preferTagsCommandOption = this.getCommandOption(OPTION_PREFER_TAGS);
        boolean preferTagsOption = preferTagsCommandOption != null ? Boolean.parseBoolean(preferTagsCommandOption) : config.preferTags;
        return preferTagsOption;
    }

    private boolean getUpdateGradlePropertiesFileOption(GitVersioningPluginConfig config, GitVersioningPluginConfig.VersionDescription gitRefConfig) {
        String updatePomCommandOption = this.getCommandOption(OPTION_UPDATE_GRADLE_PROPERTIES);
        if (updatePomCommandOption != null) {
            return Boolean.parseBoolean(updatePomCommandOption);
        }
        if (gitRefConfig.updateGradleProperties != null) {
            return gitRefConfig.updateGradleProperties;
        }
        if (config.updateGradleProperties != null) {
            return config.updateGradleProperties;
        }
        return false;
    }

    private static String slugify(String value) {
        return value.replace("/", "-").toLowerCase();
    }
}

