/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static String substituteText(String text, Map<String, String> replacements) {
        StringBuffer result = new StringBuffer();
        Pattern placeholderPattern = Pattern.compile("\\$\\{(?<key>[^}:]+)(?::(?<modifier>[-+])(?<value>[^}]*))?}");
        Matcher placeholderMatcher = placeholderPattern.matcher(text);
        while (placeholderMatcher.find()) {
            String placeholderKey = placeholderMatcher.group("key");
            String replacement = replacements.get(placeholderKey);
            String placeholderModifier = placeholderMatcher.group("modifier");
            if (placeholderModifier != null) {
                if (placeholderModifier.equals("-") && replacement == null) {
                    replacement = placeholderMatcher.group("value");
                }
                if (placeholderModifier.equals("+") && replacement != null) {
                    replacement = placeholderMatcher.group("value");
                }
            }
            if (replacement == null) continue;
            placeholderMatcher.appendReplacement(result, "");
            result.append(replacement);
        }
        placeholderMatcher.appendTail(result);
        return result.toString();
    }

    public static Map<String, String> valueGroupMap(String text, String regex) {
        HashMap<String, String> result = new HashMap<String, String>();
        Pattern groupPattern = Pattern.compile(regex);
        Matcher groupMatcher = groupPattern.matcher(text);
        if (groupMatcher.find()) {
            for (int i = 1; i <= groupMatcher.groupCount(); ++i) {
                result.put(String.valueOf(i), groupMatcher.group(i));
            }
            for (String groupName : StringUtil.patternGroupNames(groupPattern)) {
                result.put(groupName, groupMatcher.group(groupName));
            }
        }
        return result;
    }

    private static Set<String> patternGroupNames(Pattern groupPattern) {
        HashSet<String> groupNames = new HashSet<String>();
        Pattern groupNamePattern = Pattern.compile("\\(\\?<(?<name>[a-zA-Z][a-zA-Z0-9]*)>");
        Matcher groupNameMatcher = groupNamePattern.matcher(groupPattern.toString());
        while (groupNameMatcher.find()) {
            String groupName = groupNameMatcher.group("name");
            groupNames.add(groupName);
        }
        return groupNames;
    }
}

