/*
 * Decompiled with CFR 0.152.
 */
package me.piruin.quickaction;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.support.annotation.ColorInt;

final class ArrowDrawable
extends ColorDrawable {
    static final int ARROW_UP = 1;
    static final int ARROW_DOWN = 2;
    private final Paint mPaint = new Paint(1);
    private final Paint mStrokePaint;
    private final int mBackgroundColor;
    private final int mGravity;
    private Path mPath;

    ArrowDrawable(@ColorInt int foregroundColor, int gravity) {
        this.mGravity = gravity;
        this.mBackgroundColor = 0;
        this.mPaint.setColor(foregroundColor);
        this.mStrokePaint = new Paint(this.mPaint);
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setStrokeWidth(2.0f);
        this.mStrokePaint.setARGB(50, 0, 0, 0);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updatePath(bounds);
    }

    private synchronized void updatePath(Rect bounds) {
        this.mPath = new Path();
        switch (this.mGravity) {
            case 1: {
                this.mPath.moveTo(0.0f, (float)bounds.height());
                this.mPath.lineTo((float)(bounds.width() / 2), 0.0f);
                this.mPath.lineTo((float)bounds.width(), (float)bounds.height());
                this.mPath.lineTo(0.0f, (float)bounds.height());
                break;
            }
            case 2: {
                this.mPath.moveTo(0.0f, 0.0f);
                this.mPath.lineTo((float)(bounds.width() / 2), (float)bounds.height());
                this.mPath.lineTo((float)bounds.width(), 0.0f);
                this.mPath.lineTo(0.0f, 0.0f);
            }
        }
        this.mPath.close();
    }

    public void draw(Canvas canvas) {
        canvas.drawColor(this.mBackgroundColor);
        if (this.mPath == null) {
            this.updatePath(this.getBounds());
        }
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public void setColor(@ColorInt int color) {
        this.mPaint.setColor(color);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        if (this.mPaint.getColorFilter() != null) {
            return -3;
        }
        switch (this.mPaint.getColor() >>> 24) {
            case 255: {
                return -1;
            }
            case 0: {
                return -2;
            }
        }
        return -3;
    }
}

