package me.piebridge.brevent.protocol;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Objects;

import me.piebridge.brevent.protocol.base.BuildConfig;

/**
 * Created by thom on 2018/3/6.
 */
public abstract class BreventModule {

    private static final int TIMEOUT = 5000;

    private Context context;

    private String token = null;

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    protected String getToken(boolean force) {
        if ((force || token == null) && context != null) {
            token = BreventProtocolProvider.getToken(context);
        }
        return token;
    }

    protected void updateToken(String token) {
        if (context != null) {
            BreventProtocolProvider.setToken(context, token);
        }
    }

    protected BaseBreventProtocol request(BaseBreventProtocol request) throws IOException {
        try {
            request.token = getToken(false);
            return doRequest(request);
        } catch (SecurityException ignore) {
            request.token = getToken(true);
            return doRequest(request);
        }
    }

    protected BaseBreventProtocol doRequest(BaseBreventProtocol request) throws IOException {
        if (BuildConfig.DEBUG) {
            Log.d(BreventProtocolProvider.TAG, "request token: " + request.token);
        }
        try (
                Socket socket = new Socket(BaseBreventProtocol.HOST, BaseBreventProtocol.PORT);
                DataOutputStream os = new DataOutputStream(socket.getOutputStream());
                DataInputStream is = new DataInputStream(socket.getInputStream())
        ) {
            socket.setSoTimeout(TIMEOUT);
            BaseBreventProtocol.writeTo(request, os);
            os.flush();
            BaseBreventProtocol response = BaseBreventProtocol.readFromBase(is);
            if (response == BaseBreventOK.INSTANCE) {
                throw new SecurityException("no permission");
            }
            if (response != null
                    && !TextUtils.isEmpty(response.token)
                    && !Objects.equals(token, response.token)) {
                token = response.token;
                updateToken(token);
            }
            return response;
        }
    }

}
