package me.piebridge.brevent.protocol;

import android.annotation.SuppressLint;
import android.content.Context;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by thom on 2018/3/6.
 */
public class Brevent {

    @SuppressLint("StaticFieldLeak")
    static volatile Brevent singleton;

    private final Context context;

    private final Map<Class<? extends BreventModule>, BreventModule> modules;

    public Brevent(Context context, Map<Class<? extends BreventModule>, BreventModule> modules) {
        this.context = context;
        this.modules = modules;
    }

    public static Brevent init(Context context) {
        return with(context, new BreventDisabled());
    }

    public static Brevent with(Context context, BreventModule... modules) {
        if (singleton == null) {
            synchronized (Brevent.class) {
                if (singleton == null) {
                    setBrevent(new Brevent.Builder(context).modules(modules).build());
                }
            }
        }
        return singleton;
    }

    @SuppressWarnings("unchecked")
    public static <T extends BreventModule> T getModule(Class<T> clazz) {
        return (T) singleton().modules.get(clazz);
    }

    static Brevent singleton() {
        if (singleton == null) {
            throw new IllegalStateException("Must Initialize Brevent before using singleton()");
        } else {
            return singleton;
        }
    }

    static Map<Class<? extends BreventModule>, BreventModule> getModuleMap(
            Collection<? extends BreventModule> modules) {
        @SuppressWarnings("unchecked")
        HashMap<Class<? extends BreventModule>, BreventModule> map = new HashMap(modules.size());
        addToModuleMap(map, modules);
        return map;
    }

    static void addToModuleMap(Map<Class<? extends BreventModule>, BreventModule> map,
                               Collection<? extends BreventModule> modules) {
        for (BreventModule module : modules) {
            map.put(module.getClass(), module);
        }
    }

    static void setBrevent(Brevent brevent) {
        singleton = brevent;
        brevent.init();
    }

    private void init() {
        initModules(context);
    }

    private void initModules(Context context) {
        for (BreventModule module : modules.values()) {
            module.setContext(context);
        }
    }

    public static class Builder {

        private final Context context;

        private BreventModule[] modules;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            } else {
                this.context = context;
            }
        }

        public Builder modules(BreventModule... modules) {
            if (this.modules != null) {
                throw new IllegalStateException("Modules already set.");
            } else {
                this.modules = modules;
                return this;
            }
        }

        public Brevent build() {

            Map<Class<? extends BreventModule>, BreventModule> modulesMap;
            if (this.modules == null) {
                modulesMap = new HashMap<>();
            } else {
                modulesMap = getModuleMap(Arrays.asList(this.modules));
            }

            return new Brevent(context.getApplicationContext(), modulesMap);
        }
    }

}
