/*
 * Decompiled with CFR 0.152.
 */
package me.piebridge.brevent.protocol;

import android.annotation.SuppressLint;
import android.content.Context;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.piebridge.brevent.protocol.BreventDisabled;
import me.piebridge.brevent.protocol.BreventModule;

public class Brevent {
    @SuppressLint(value={"StaticFieldLeak"})
    static volatile Brevent singleton;
    private final Context context;
    private final Map<Class<? extends BreventModule>, BreventModule> modules;

    public Brevent(Context context, Map<Class<? extends BreventModule>, BreventModule> modules) {
        this.context = context;
        this.modules = modules;
    }

    public static Brevent init(Context context) {
        return Brevent.with(context, new BreventDisabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Brevent with(Context context, BreventModule ... modules) {
        if (singleton != null) return singleton;
        Class<Brevent> clazz = Brevent.class;
        synchronized (Brevent.class) {
            if (singleton != null) return singleton;
            Brevent.setBrevent(new Builder(context).modules(modules).build());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return singleton;
        }
    }

    public static <T extends BreventModule> T getModule(Class<T> clazz) {
        return (T)Brevent.singleton().modules.get(clazz);
    }

    static Brevent singleton() {
        if (singleton == null) {
            throw new IllegalStateException("Must Initialize Brevent before using singleton()");
        }
        return singleton;
    }

    static Map<Class<? extends BreventModule>, BreventModule> getModuleMap(Collection<? extends BreventModule> modules) {
        HashMap<Class<? extends BreventModule>, BreventModule> map = new HashMap<Class<? extends BreventModule>, BreventModule>(modules.size());
        Brevent.addToModuleMap(map, modules);
        return map;
    }

    static void addToModuleMap(Map<Class<? extends BreventModule>, BreventModule> map, Collection<? extends BreventModule> modules) {
        for (BreventModule breventModule : modules) {
            map.put(breventModule.getClass(), breventModule);
        }
    }

    static void setBrevent(Brevent brevent) {
        singleton = brevent;
        brevent.init();
    }

    private void init() {
        this.initModules(this.context);
    }

    private void initModules(Context context) {
        for (BreventModule module : this.modules.values()) {
            module.setContext(context);
        }
    }

    public static class Builder {
        private final Context context;
        private BreventModule[] modules;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context;
        }

        public Builder modules(BreventModule ... modules) {
            if (this.modules != null) {
                throw new IllegalStateException("Modules already set.");
            }
            this.modules = modules;
            return this;
        }

        public Brevent build() {
            Map<Object, Object> modulesMap = this.modules == null ? new HashMap() : Brevent.getModuleMap(Arrays.asList(this.modules));
            return new Brevent(this.context.getApplicationContext(), modulesMap);
        }
    }
}

