/*
 * Decompiled with CFR 0.152.
 */
package me.piebridge.brevent.protocol;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.util.Objects;
import java.util.UUID;

public class BreventProtocolProvider
extends ContentProvider {
    public static final String TAG = "BreventAPI";
    private static final String SP_NAME = "brevent";
    private static final String KEY_LEAST = "least";
    private static final String KEY_MOST = "most";
    private String token;

    private static Uri getUri(Context context) {
        return new Uri.Builder().scheme("content").authority(context.getPackageName() + ".brevent.token").build();
    }

    public static void setToken(Context context, String token) {
        ContentValues values = new ContentValues();
        values.put("android.intent.extra.remote_intent_token", token);
        context.getContentResolver().update(BreventProtocolProvider.getUri(context), values, null, null);
    }

    public static String getToken(Context context) {
        try (Cursor cursor = context.getContentResolver().query(BreventProtocolProvider.getUri(context), null, null, null, null);){
            if (cursor != null) {
                cursor.moveToFirst();
                String string = cursor.getString(0);
                return string;
            }
            String string = null;
            return string;
        }
    }

    public boolean onCreate() {
        return false;
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        MatrixCursor cursor = new MatrixCursor(new String[]{"android.intent.extra.remote_intent_token"}, 1);
        if (this.token == null) {
            this.token = this.loadToken();
            Log.d((String)TAG, (String)"load token");
        }
        cursor.addRow((Object[])new String[]{this.token});
        return cursor;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return "text/plain";
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        throw new UnsupportedOperationException();
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        throw new UnsupportedOperationException();
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        String value;
        if (values != null && !Objects.equals(this.token, value = (String)values.get("android.intent.extra.remote_intent_token"))) {
            String action = this.token == null ? "init token" : "update token";
            this.token = value;
            Log.d((String)TAG, (String)action);
            this.saveToken();
            return 1;
        }
        return 0;
    }

    private void saveToken() {
        UUID uuid = UUID.fromString(this.token);
        long least = uuid.getLeastSignificantBits();
        long most = uuid.getMostSignificantBits();
        this.getContext().getApplicationContext().getSharedPreferences(SP_NAME, 0).edit().putLong(KEY_LEAST, least).putLong(KEY_MOST, most ^= (least ^= (long)this.getContext().getPackageName().hashCode())).apply();
    }

    private String loadToken() {
        SharedPreferences sp = this.getContext().getApplicationContext().getSharedPreferences(SP_NAME, 0);
        long least = sp.getLong(KEY_LEAST, 0L);
        long most = sp.getLong(KEY_MOST, 0L);
        most ^= least;
        return new UUID(most, least ^= (long)this.getContext().getPackageName().hashCode()).toString();
    }
}

