package me.piebridge.brevent.protocol;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.CallSuper;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;

/**
 * Created by thom on 2018/3/4.
 */
public abstract class AbstractBreventServerReceiver extends BroadcastReceiver {

    @Override
    @CallSuper
    @RequiresPermission(BreventDisabled.PERMISSION)
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("me.piebridge.brevent.intent.action.BREVENT".equals(action)) {
            String token = intent.getStringExtra(Intent.EXTRA_REMOTE_INTENT_TOKEN);
            if (!TextUtils.isEmpty(token)) {
                onToken(token);
                BreventProtocolProvider.setToken(context, token);
            }
        }
    }

    protected void onToken(String token) {
        // empty
    }

}
