/*
 * Decompiled with CFR 0.152.
 */
package me.piebridge.brevent.protocol;

import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.WorkerThread;
import java.io.IOException;
import java.util.List;
import me.piebridge.brevent.protocol.BaseBreventProtocol;
import me.piebridge.brevent.protocol.Brevent;
import me.piebridge.brevent.protocol.BreventDisabledGetState;
import me.piebridge.brevent.protocol.BreventDisabledPackagesRequest;
import me.piebridge.brevent.protocol.BreventDisabledPackagesResponse;
import me.piebridge.brevent.protocol.BreventDisabledSetState;
import me.piebridge.brevent.protocol.BreventDisabledStatus;
import me.piebridge.brevent.protocol.BreventModule;

@WorkerThread
public class BreventDisabled
extends BreventModule {
    public static final String PERMISSION = "me.piebridge.brevent.permission.BREVENT_DISABLED";

    public static BreventDisabled getInstance() {
        return Brevent.getModule(BreventDisabled.class);
    }

    public boolean hasBrevent() {
        try {
            PermissionInfo permission = this.getContext().getPackageManager().getPermissionInfo(PERMISSION, 0);
            return (permission.protectionLevel & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException ignore) {
            return false;
        }
    }

    @RequiresPermission(value="me.piebridge.brevent.permission.BREVENT_DISABLED")
    public boolean isAvailable() throws IOException {
        BaseBreventProtocol response = this.request(new BreventDisabledStatus(true));
        return response instanceof BreventDisabledStatus && ((BreventDisabledStatus)response).enabled;
    }

    @Nullable
    @RequiresPermission(value="me.piebridge.brevent.permission.BREVENT_DISABLED")
    public List<String> getDisabledPackages(int uid) throws IOException {
        BaseBreventProtocol response = this.request(new BreventDisabledPackagesRequest(uid));
        if (response instanceof BreventDisabledPackagesResponse) {
            return ((BreventDisabledPackagesResponse)response).packageNames;
        }
        return null;
    }

    @RequiresPermission(value="me.piebridge.brevent.permission.BREVENT_DISABLED")
    public boolean isDisabled(String packageName, int uid) throws IOException {
        BaseBreventProtocol response = this.request(new BreventDisabledGetState(packageName, uid, false));
        return response instanceof BreventDisabledGetState && ((BreventDisabledGetState)response).disabled;
    }

    @RequiresPermission(value="me.piebridge.brevent.permission.BREVENT_DISABLED")
    public boolean setPackageEnabled(String packageName, int uid, boolean enable) throws IOException {
        BaseBreventProtocol response = this.request(new BreventDisabledSetState(packageName, uid, enable));
        return response instanceof BreventDisabledSetState && ((BreventDisabledSetState)response).enable;
    }
}

