package me.piebridge.brevent.protocol;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import java.util.Objects;
import java.util.UUID;

import me.piebridge.brevent.protocol.base.BuildConfig;

/**
 * Created by thom on 2018/3/5.
 */
public class BreventProtocolProvider extends ContentProvider {

    public static final String TAG = "BreventAPI";

    private static final String SP_NAME = "brevent";

    private static final String KEY_LEAST = "least";

    private static final String KEY_MOST = "most";

    private String token;

    private static Uri getUri(Context context) {
        return new Uri.Builder().scheme("content")
                .authority(context.getPackageName() + ".brevent.token")
                .build();
    }

    public static void setToken(Context context, String token) {
        ContentValues values = new ContentValues();
        values.put(Intent.EXTRA_REMOTE_INTENT_TOKEN, token);
        context.getContentResolver().update(getUri(context), values, null, null);
    }

    public static String getToken(Context context) {
        try (
                Cursor cursor = context.getContentResolver().query(getUri(context),
                        null, null, null, null)
        ) {
            if (cursor != null) {
                cursor.moveToFirst();
                return cursor.getString(0);
            } else {
                return null;
            }
        }
    }

    @Override
    public boolean onCreate() {
        return false;
    }

    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection,
                        @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        MatrixCursor cursor = new MatrixCursor(new String[] {
                Intent.EXTRA_REMOTE_INTENT_TOKEN
        }, 1);
        if (token == null) {
            token = loadToken();
            if (BuildConfig.DEBUG) {
                Log.d(TAG, "load token: " + token);
            } else {
                Log.d(TAG, "load token");
            }
        }
        cursor.addRow(new String[] {token});
        return cursor;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return "text/plain";
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String selection,
                      @Nullable String[] selectionArgs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection,
                      @Nullable String[] selectionArgs) {
        if (values != null) {
            String value = (String) values.get(Intent.EXTRA_REMOTE_INTENT_TOKEN);
            if (!Objects.equals(token, value)) {
                String action = (token == null) ? "init token" : "update token";
                token = value;
                if (BuildConfig.DEBUG) {
                    Log.d(TAG, action + ": " + token);
                } else {
                    Log.d(TAG, action);
                }
                saveToken();
                return 1;
            }
        }
        return 0;
    }

    private void saveToken() {
        UUID uuid = UUID.fromString(token);
        long least = uuid.getLeastSignificantBits();
        long most = uuid.getMostSignificantBits();
        least ^= getContext().getPackageName().hashCode();
        most ^= least;
        getContext().getApplicationContext()
                .getSharedPreferences(SP_NAME, Context.MODE_PRIVATE)
                .edit().putLong(KEY_LEAST, least).putLong(KEY_MOST, most).apply();
    }

    private String loadToken() {
        SharedPreferences sp = getContext().getApplicationContext()
                .getSharedPreferences(SP_NAME, Context.MODE_PRIVATE);
        long least = sp.getLong(KEY_LEAST, 0);
        long most = sp.getLong(KEY_MOST, 0);
        most ^= least;
        least ^= getContext().getPackageName().hashCode();
        return new UUID(most, least).toString();
    }

}
