/*
 * Decompiled with CFR 0.152.
 */
package me.piebridge.brevent.protocol;

import android.os.Parcel;
import android.support.annotation.CallSuper;
import android.support.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import me.piebridge.brevent.protocol.BaseBreventOK;
import me.piebridge.brevent.protocol.BreventDisabledGetState;
import me.piebridge.brevent.protocol.BreventDisabledPackagesRequest;
import me.piebridge.brevent.protocol.BreventDisabledPackagesResponse;
import me.piebridge.brevent.protocol.BreventDisabledSetState;
import me.piebridge.brevent.protocol.BreventDisabledStatus;

public abstract class BaseBreventProtocol {
    public static final InetAddress HOST = InetAddress.getLoopbackAddress();
    public static final int PORT = 59526;
    public static final int VERSION = 190;
    public static final int BASE_STATUS_OK = 99;
    public static final int DISABLED_STATUS = 100;
    public static final int DISABLED_PACKAGES_REQUEST = 101;
    public static final int DISABLED_PACKAGES_RESPONSE = 102;
    public static final int DISABLED_GET_STATE = 103;
    public static final int DISABLED_SET_STATE = 104;
    private int mVersion;
    private int mAction;
    public boolean retry;
    public String token;

    public BaseBreventProtocol(int action) {
        this.mVersion = 190;
        this.mAction = action;
        this.token = "";
    }

    BaseBreventProtocol(Parcel in) {
        this.mVersion = in.readInt();
        this.mAction = in.readInt();
        this.token = in.readString();
    }

    @CallSuper
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mVersion);
        dest.writeInt(this.mAction);
        dest.writeString(this.token);
    }

    public final int getAction() {
        return this.mAction;
    }

    public final boolean versionMismatched() {
        return this.mVersion != 190;
    }

    public static void writeTo(BaseBreventProtocol protocol, DataOutputStream os) throws IOException {
        Parcel parcel = Parcel.obtain();
        protocol.writeToParcel(parcel, 0);
        byte[] bytes = parcel.marshall();
        parcel.recycle();
        bytes = BaseBreventProtocol.compress(bytes);
        int size = bytes.length;
        if (size > 65535) {
            throw new IOTooLargeException(size);
        }
        os.writeShort(size);
        os.write(bytes);
    }

    @Nullable
    public static BaseBreventProtocol readFromBase(DataInputStream is) throws IOException {
        int length;
        int size = is.readUnsignedShort();
        if (size == 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        int offset = 0;
        int remain = bytes.length;
        while (remain > 0 && (length = is.read(bytes, offset, remain)) != -1) {
            if (length <= 0) continue;
            offset += length;
            remain -= length;
        }
        return BaseBreventProtocol.unwrapBase(BaseBreventProtocol.uncompress(bytes));
    }

    protected String getActionName(int action) {
        switch (action) {
            case 99: {
                return "base_status_ok";
            }
            case 100: {
                return "disabled_status";
            }
            case 101: {
                return "disabled_packages_request";
            }
            case 102: {
                return "disabled_packages_response";
            }
            case 103: {
                return "disabled_get_state";
            }
            case 104: {
                return "disabled_set_state";
            }
        }
        return "(unknown: " + action + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseBreventProtocol unwrapBase(byte[] bytes) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(bytes, 0, bytes.length);
        parcel.setDataPosition(0);
        parcel.readInt();
        int action = parcel.readInt();
        parcel.setDataPosition(0);
        try {
            BaseBreventProtocol baseBreventProtocol = BaseBreventProtocol.unwrapBase(action, parcel);
            return baseBreventProtocol;
        }
        finally {
            parcel.recycle();
        }
    }

    public static BaseBreventProtocol unwrapBase(int action, Parcel parcel) {
        switch (action) {
            case 99: {
                return BaseBreventOK.INSTANCE;
            }
            case 100: {
                return new BreventDisabledStatus(parcel);
            }
            case 101: {
                return new BreventDisabledPackagesRequest(parcel);
            }
            case 102: {
                return new BreventDisabledPackagesResponse(parcel);
            }
            case 103: {
                return new BreventDisabledGetState(parcel);
            }
            case 104: {
                return new BreventDisabledSetState(parcel);
            }
        }
        return null;
    }

    public static byte[] compress(byte[] bytes) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            gos.write(bytes);
            gos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] uncompress(byte[] compressed) {
        try {
            int length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
            GZIPInputStream gis = new GZIPInputStream(bais);
            byte[] buffer = new byte[4096];
            while ((length = gis.read(buffer)) != -1) {
                if (length <= 0) continue;
                baos.write(buffer, 0, length);
            }
            gis.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "version: " + this.mVersion + ", action: " + this.getActionName(this.mAction);
    }

    public static class IOTooLargeException
    extends IOException {
        private final int mSize;

        IOTooLargeException(int size) {
            this.mSize = size;
        }

        public int getSize() {
            return this.mSize;
        }
    }
}

