/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import com.android.setupwizardlib.R;

public class StatusBarBackgroundLayout
extends FrameLayout {
    private Drawable mStatusBarBackground;
    private Object mLastInsets;

    public StatusBarBackgroundLayout(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public StatusBarBackgroundLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    @TargetApi(value=11)
    public StatusBarBackgroundLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwStatusBarBackgroundLayout, defStyleAttr, 0);
        Drawable statusBarBackground = a.getDrawable(R.styleable.SuwStatusBarBackgroundLayout_suwStatusBarBackground);
        this.setStatusBarBackground(statusBarBackground);
        a.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (Build.VERSION.SDK_INT >= 21 && this.mLastInsets == null) {
            this.requestApplyInsets();
        }
    }

    protected void onDraw(Canvas canvas) {
        int insetTop;
        super.onDraw(canvas);
        if (Build.VERSION.SDK_INT >= 21 && this.mLastInsets != null && (insetTop = ((WindowInsets)this.mLastInsets).getSystemWindowInsetTop()) > 0) {
            this.mStatusBarBackground.setBounds(0, 0, this.getWidth(), insetTop);
            this.mStatusBarBackground.draw(canvas);
        }
    }

    public void setStatusBarBackground(Drawable background) {
        this.mStatusBarBackground = background;
        if (Build.VERSION.SDK_INT >= 21) {
            this.setWillNotDraw(background == null);
            this.setFitsSystemWindows(background != null);
            this.invalidate();
        }
    }

    public Drawable getStatusBarBackground() {
        return this.mStatusBarBackground;
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        this.mLastInsets = insets;
        return super.onApplyWindowInsets(insets);
    }
}

