/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.items;

import android.content.Context;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.android.setupwizardlib.items.IItem;
import com.android.setupwizardlib.items.ItemHierarchy;

public class ItemAdapter
extends BaseAdapter
implements ItemHierarchy.Observer {
    private final ItemHierarchy mItemHierarchy;
    private ViewTypes mViewTypes = new ViewTypes();

    public ItemAdapter(ItemHierarchy hierarchy) {
        this.mItemHierarchy = hierarchy;
        this.mItemHierarchy.registerObserver(this);
        this.refreshViewTypes();
    }

    public int getCount() {
        return this.mItemHierarchy.getCount();
    }

    public IItem getItem(int position) {
        return this.mItemHierarchy.getItemAt(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        IItem item = this.getItem(position);
        int layoutRes = item.getLayoutResource();
        return this.mViewTypes.get(layoutRes);
    }

    public int getViewTypeCount() {
        return this.mViewTypes.size();
    }

    private void refreshViewTypes() {
        for (int i = 0; i < this.getCount(); ++i) {
            IItem item = this.getItem(i);
            this.mViewTypes.add(item.getLayoutResource());
        }
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        IItem item = this.getItem(position);
        if (convertView == null) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            convertView = inflater.inflate(item.getLayoutResource(), parent, false);
        }
        item.onBindView(convertView);
        return convertView;
    }

    @Override
    public void onChanged(ItemHierarchy hierarchy) {
        this.refreshViewTypes();
        this.notifyDataSetChanged();
    }

    @Override
    public void onItemRangeChanged(ItemHierarchy itemHierarchy, int positionStart, int itemCount) {
        this.onChanged(itemHierarchy);
    }

    @Override
    public void onItemRangeInserted(ItemHierarchy itemHierarchy, int positionStart, int itemCount) {
        this.onChanged(itemHierarchy);
    }

    @Override
    public void onItemRangeMoved(ItemHierarchy itemHierarchy, int fromPosition, int toPosition, int itemCount) {
        this.onChanged(itemHierarchy);
    }

    @Override
    public void onItemRangeRemoved(ItemHierarchy itemHierarchy, int positionStart, int itemCount) {
        this.onChanged(itemHierarchy);
    }

    public boolean isEnabled(int position) {
        return this.getItem(position).isEnabled();
    }

    public ItemHierarchy findItemById(int id2) {
        return this.mItemHierarchy.findItemById(id2);
    }

    public ItemHierarchy getRootItemHierarchy() {
        return this.mItemHierarchy;
    }

    private static class ViewTypes {
        private SparseIntArray mPositionMap = new SparseIntArray();
        private int nextPosition = 0;

        private ViewTypes() {
        }

        public int add(int id2) {
            if (this.mPositionMap.indexOfKey(id2) < 0) {
                this.mPositionMap.put(id2, this.nextPosition);
                ++this.nextPosition;
            }
            return this.mPositionMap.get(id2);
        }

        public int size() {
            return this.mPositionMap.size();
        }

        public int get(int id2) {
            return this.mPositionMap.get(id2);
        }
    }
}

