/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.items;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.items.ItemHierarchy;
import java.util.ArrayList;

public abstract class AbstractItemHierarchy
implements ItemHierarchy {
    private static final String TAG = "AbstractItemHierarchy";
    private ArrayList<ItemHierarchy.Observer> mObservers = new ArrayList();
    private int mId = 0;

    public AbstractItemHierarchy() {
    }

    public AbstractItemHierarchy(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwAbstractItem);
        this.mId = a.getResourceId(R.styleable.SuwAbstractItem_android_id, 0);
        a.recycle();
    }

    public void setId(int id2) {
        this.mId = id2;
    }

    public int getId() {
        return this.mId;
    }

    public int getViewId() {
        return this.getId();
    }

    @Override
    public void registerObserver(ItemHierarchy.Observer observer) {
        this.mObservers.add(observer);
    }

    @Override
    public void unregisterObserver(ItemHierarchy.Observer observer) {
        this.mObservers.remove(observer);
    }

    public void notifyChanged() {
        for (ItemHierarchy.Observer observer : this.mObservers) {
            observer.onChanged(this);
        }
    }

    public void notifyItemRangeChanged(int position, int itemCount) {
        if (position < 0) {
            Log.w((String)TAG, (String)("notifyItemRangeChanged: Invalid position=" + position));
            return;
        }
        if (itemCount < 0) {
            Log.w((String)TAG, (String)("notifyItemRangeChanged: Invalid itemCount=" + itemCount));
            return;
        }
        for (ItemHierarchy.Observer observer : this.mObservers) {
            observer.onItemRangeChanged(this, position, itemCount);
        }
    }

    public void notifyItemRangeInserted(int position, int itemCount) {
        if (position < 0) {
            Log.w((String)TAG, (String)("notifyItemRangeInserted: Invalid position=" + position));
            return;
        }
        if (itemCount < 0) {
            Log.w((String)TAG, (String)("notifyItemRangeInserted: Invalid itemCount=" + itemCount));
            return;
        }
        for (ItemHierarchy.Observer observer : this.mObservers) {
            observer.onItemRangeInserted(this, position, itemCount);
        }
    }

    public void notifyItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
        if (fromPosition < 0) {
            Log.w((String)TAG, (String)("notifyItemRangeMoved: Invalid fromPosition=" + fromPosition));
            return;
        }
        if (toPosition < 0) {
            Log.w((String)TAG, (String)("notifyItemRangeMoved: Invalid toPosition=" + toPosition));
            return;
        }
        if (itemCount < 0) {
            Log.w((String)TAG, (String)("notifyItemRangeMoved: Invalid itemCount=" + itemCount));
            return;
        }
        for (ItemHierarchy.Observer observer : this.mObservers) {
            observer.onItemRangeMoved(this, fromPosition, toPosition, itemCount);
        }
    }

    public void notifyItemRangeRemoved(int position, int itemCount) {
        if (position < 0) {
            Log.w((String)TAG, (String)("notifyItemRangeInserted: Invalid position=" + position));
            return;
        }
        if (itemCount < 0) {
            Log.w((String)TAG, (String)("notifyItemRangeInserted: Invalid itemCount=" + itemCount));
            return;
        }
        for (ItemHierarchy.Observer observer : this.mObservers) {
            observer.onItemRangeRemoved(this, position, itemCount);
        }
    }
}

