/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.android.setupwizardlib.DividerItemDecoration;
import com.android.setupwizardlib.R;

public class HeaderRecyclerView
extends RecyclerView {
    private View mHeader;
    private int mHeaderRes;

    public HeaderRecyclerView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public HeaderRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public HeaderRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SuwHeaderRecyclerView, defStyleAttr, 0);
        this.mHeaderRes = a.getResourceId(R.styleable.SuwHeaderRecyclerView_suwHeader, 0);
        a.recycle();
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        int numberOfHeaders = this.mHeader != null ? 1 : 0;
        event.setItemCount(event.getItemCount() - numberOfHeaders);
        event.setFromIndex(Math.max(event.getFromIndex() - numberOfHeaders, 0));
        if (Build.VERSION.SDK_INT >= 14) {
            event.setToIndex(Math.max(event.getToIndex() - numberOfHeaders, 0));
        }
    }

    public View getHeader() {
        return this.mHeader;
    }

    public void setHeader(View header) {
        this.mHeader = header;
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout2) {
        super.setLayoutManager(layout2);
        if (layout2 != null && this.mHeader == null && this.mHeaderRes != 0) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
            this.mHeader = inflater.inflate(this.mHeaderRes, (ViewGroup)this, false);
        }
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (this.mHeader != null && adapter != null) {
            HeaderAdapter headerAdapter = new HeaderAdapter(adapter);
            headerAdapter.setHeader(this.mHeader);
            adapter = headerAdapter;
        }
        super.setAdapter((RecyclerView.Adapter)adapter);
    }

    public static class HeaderAdapter<CVH extends RecyclerView.ViewHolder>
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private static final int HEADER_VIEW_TYPE = Integer.MAX_VALUE;
        private RecyclerView.Adapter<CVH> mAdapter;
        private View mHeader;
        private final RecyclerView.AdapterDataObserver mObserver = new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                HeaderAdapter.this.notifyDataSetChanged();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                if (HeaderAdapter.this.mHeader != null) {
                    ++positionStart;
                }
                HeaderAdapter.this.notifyItemRangeChanged(positionStart, itemCount);
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                if (HeaderAdapter.this.mHeader != null) {
                    ++positionStart;
                }
                HeaderAdapter.this.notifyItemRangeInserted(positionStart, itemCount);
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                if (HeaderAdapter.this.mHeader != null) {
                    ++fromPosition;
                    ++toPosition;
                }
                for (int i = 0; i < itemCount; ++i) {
                    HeaderAdapter.this.notifyItemMoved(fromPosition + i, toPosition + i);
                }
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                if (HeaderAdapter.this.mHeader != null) {
                    ++positionStart;
                }
                HeaderAdapter.this.notifyItemRangeRemoved(positionStart, itemCount);
            }
        };

        public HeaderAdapter(RecyclerView.Adapter<CVH> adapter) {
            this.mAdapter = adapter;
            this.mAdapter.registerAdapterDataObserver(this.mObserver);
            this.setHasStableIds(this.mAdapter.hasStableIds());
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            if (viewType == Integer.MAX_VALUE) {
                FrameLayout frameLayout = new FrameLayout(parent.getContext());
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
                frameLayout.setLayoutParams((ViewGroup.LayoutParams)params);
                return new HeaderViewHolder((View)frameLayout);
            }
            return this.mAdapter.onCreateViewHolder(parent, viewType);
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (this.mHeader != null) {
                --position;
            }
            if (holder instanceof HeaderViewHolder) {
                if (this.mHeader == null) {
                    throw new IllegalStateException("HeaderViewHolder cannot find mHeader");
                }
                if (this.mHeader.getParent() != null) {
                    ((ViewGroup)this.mHeader.getParent()).removeView(this.mHeader);
                }
                FrameLayout mHeaderParent = (FrameLayout)holder.itemView;
                mHeaderParent.addView(this.mHeader);
            } else {
                this.mAdapter.onBindViewHolder(holder, position);
            }
        }

        public int getItemViewType(int position) {
            if (this.mHeader != null) {
                --position;
            }
            if (position < 0) {
                return Integer.MAX_VALUE;
            }
            return this.mAdapter.getItemViewType(position);
        }

        public int getItemCount() {
            int count = this.mAdapter.getItemCount();
            if (this.mHeader != null) {
                ++count;
            }
            return count;
        }

        public long getItemId(int position) {
            if (this.mHeader != null) {
                --position;
            }
            if (position < 0) {
                return Long.MAX_VALUE;
            }
            return this.mAdapter.getItemId(position);
        }

        public void setHeader(View header) {
            this.mHeader = header;
        }

        public RecyclerView.Adapter<CVH> getWrappedAdapter() {
            return this.mAdapter;
        }
    }

    private static class HeaderViewHolder
    extends RecyclerView.ViewHolder
    implements DividerItemDecoration.DividedViewHolder {
        HeaderViewHolder(View itemView) {
            super(itemView);
        }

        @Override
        public boolean isDividerAllowedAbove() {
            return false;
        }

        @Override
        public boolean isDividerAllowedBelow() {
            return false;
        }
    }
}

