/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.widget.Checkable;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;

public class CheckableLinearLayout
extends LinearLayout
implements Checkable {
    private boolean mChecked = false;

    public CheckableLinearLayout(Context context) {
        super(context);
        this.setFocusable(true);
    }

    public CheckableLinearLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setFocusable(true);
    }

    @TargetApi(value=11)
    public CheckableLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setFocusable(true);
    }

    @TargetApi(value=21)
    public CheckableLinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setFocusable(true);
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        if (this.mChecked) {
            int[] superStates = super.onCreateDrawableState(extraSpace + 1);
            int[] checked = new int[]{0x10100A0};
            return CheckableLinearLayout.mergeDrawableStates((int[])superStates, (int[])checked);
        }
        return super.onCreateDrawableState(extraSpace);
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
        this.refreshDrawableState();
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }
}

