/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.android.setupwizardlib.R;

public class ButtonBarLayout
extends LinearLayout {
    private boolean mStacked = false;
    private int mOriginalPaddingLeft;
    private int mOriginalPaddingRight;

    public ButtonBarLayout(Context context) {
        super(context);
    }

    public ButtonBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.setStacked(false);
        boolean needsRemeasure = false;
        int initialWidthMeasureSpec = widthMeasureSpec;
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000) {
            initialWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            needsRemeasure = true;
        }
        super.onMeasure(initialWidthMeasureSpec, heightMeasureSpec);
        if (this.getMeasuredWidth() > widthSize) {
            this.setStacked(true);
            needsRemeasure = true;
        }
        if (needsRemeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void setStacked(boolean stacked) {
        int i;
        if (this.mStacked == stacked) {
            return;
        }
        this.mStacked = stacked;
        int childCount = this.getChildCount();
        for (i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LinearLayout.LayoutParams childParams = (LinearLayout.LayoutParams)child.getLayoutParams();
            if (stacked) {
                child.setTag(R.id.suw_original_weight, (Object)Float.valueOf(childParams.weight));
                childParams.weight = 0.0f;
            } else {
                Float weight = (Float)child.getTag(R.id.suw_original_weight);
                if (weight != null) {
                    childParams.weight = weight.floatValue();
                }
            }
            child.setLayoutParams((ViewGroup.LayoutParams)childParams);
        }
        this.setOrientation(stacked ? 1 : 0);
        for (i = childCount - 1; i >= 0; --i) {
            this.bringChildToFront(this.getChildAt(i));
        }
        if (stacked) {
            this.mOriginalPaddingLeft = this.getPaddingLeft();
            this.mOriginalPaddingRight = this.getPaddingRight();
            int paddingHorizontal = Math.max(this.mOriginalPaddingLeft, this.mOriginalPaddingRight);
            this.setPadding(paddingHorizontal, this.getPaddingTop(), paddingHorizontal, this.getPaddingBottom());
        } else {
            this.setPadding(this.mOriginalPaddingLeft, this.getPaddingTop(), this.mOriginalPaddingRight, this.getPaddingBottom());
        }
    }
}

