/*
 * Decompiled with CFR 0.152.
 */
package me.ledge.link.api.vos.datapoints;

import com.google.gson.JsonObject;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import me.ledge.link.api.vos.datapoints.DataPointVo;

public class PhoneNumberVo
extends DataPointVo {
    public Phonenumber.PhoneNumber phoneNumber;

    public PhoneNumberVo() {
        this((String)null, false, false);
    }

    public PhoneNumberVo(String phone, boolean verified, boolean notSpecified) {
        super(DataPointVo.DataPointType.Phone, verified, notSpecified);
        this.init();
        try {
            Phonenumber.PhoneNumber number = PhoneNumberUtil.getInstance().parse(phone, "US");
            this.setPhone(number);
        }
        catch (NumberParseException e) {
            this.phoneNumber = null;
        }
    }

    public void init() {
        this.phoneNumber = new Phonenumber.PhoneNumber();
    }

    public Phonenumber.PhoneNumber getPhone() {
        return this.phoneNumber;
    }

    public String getPhoneAsString() {
        return "+" + String.valueOf(this.phoneNumber.getCountryCode()) + String.valueOf(this.phoneNumber.getNationalNumber());
    }

    public void setPhone(String phone) {
        try {
            Phonenumber.PhoneNumber number = PhoneNumberUtil.getInstance().parse(phone, "US");
            this.setPhone(number);
        }
        catch (NumberParseException npe) {
            this.phoneNumber = null;
        }
    }

    public void setPhone(Phonenumber.PhoneNumber number) {
        this.phoneNumber = number != null && PhoneNumberUtil.getInstance().isValidNumber(number) ? number : null;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject gsonObject = super.toJSON();
        gsonObject.addProperty("data_type", "phone");
        gsonObject.addProperty("phone_number", String.valueOf(this.phoneNumber.getNationalNumber()));
        gsonObject.addProperty("country_code", String.valueOf(this.phoneNumber.getCountryCode()));
        return gsonObject;
    }

    public String toString() {
        return this.getPhoneAsString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PhoneNumberVo that = (PhoneNumberVo)o;
        return this.phoneNumber != null ? this.phoneNumber.equals((Object)that.phoneNumber) : that.phoneNumber == null;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.phoneNumber != null ? this.phoneNumber.hashCode() : 0);
    }
}

