/*
 * Decompiled with CFR 0.152.
 */
package me.ledge.link.api.vos.datapoints;

import com.google.gson.JsonObject;

public class VerificationVo {
    private VerificationStatus mVerificationStatus;
    private String mSecret;
    private String mVerificationId;
    private String mVerificationType;

    public VerificationVo() {
        this.mVerificationId = null;
        this.mSecret = null;
        this.mVerificationStatus = null;
        this.mVerificationType = null;
    }

    public VerificationVo(String verificationId) {
        this.mVerificationId = verificationId;
        this.mSecret = null;
        this.mVerificationStatus = null;
        this.mVerificationType = null;
    }

    public VerificationVo(String verificationId, String verificationType) {
        this.mVerificationId = verificationId;
        this.mSecret = null;
        this.mVerificationStatus = null;
        this.mVerificationType = verificationType;
    }

    public VerificationVo(String verificationId, VerificationStatus status, String secret) {
        this.mVerificationId = verificationId;
        this.mSecret = secret;
        this.mVerificationStatus = status;
    }

    public String getVerificationId() {
        return this.mVerificationId;
    }

    public void setVerificationId(String mVerificationId) {
        this.mVerificationId = mVerificationId;
    }

    public String getSecret() {
        return this.mSecret;
    }

    public void setSecret(String secret) {
        this.mSecret = secret;
    }

    public void setVerificationStatus(String verificationStatus) {
        try {
            this.mVerificationStatus = VerificationStatus.valueOf(verificationStatus.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.mVerificationStatus = null;
        }
    }

    public String getVerificationType() {
        return this.mVerificationType;
    }

    public void setVerificationType(String verificationType) {
        this.mVerificationType = verificationType;
    }

    public boolean isVerified() {
        return this.mVerificationStatus == VerificationStatus.PASSED;
    }

    public JsonObject toJSON() {
        JsonObject gsonObject = new JsonObject();
        gsonObject.addProperty("secret", this.mSecret);
        gsonObject.addProperty("verification_id", String.valueOf(this.mVerificationId));
        gsonObject.addProperty("verification_type", this.mVerificationType);
        return gsonObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationVo that = (VerificationVo)o;
        if (this.mVerificationStatus != that.mVerificationStatus) {
            return false;
        }
        if (this.mSecret != null ? !this.mSecret.equals(that.mSecret) : that.mSecret != null) {
            return false;
        }
        return this.mVerificationId != null ? !this.mVerificationId.equals(that.mVerificationId) : that.mVerificationId != null;
    }

    public int hashCode() {
        int result = this.mVerificationStatus != null ? this.mVerificationStatus.hashCode() : 0;
        result = 31 * result + (this.mSecret != null ? this.mSecret.hashCode() : 0);
        result = 31 * result + (this.mVerificationId != null ? this.mVerificationId.hashCode() : 0);
        return result;
    }

    public static enum VerificationStatus {
        PENDING,
        PASSED,
        FAILED;

    }
}

