/*
 * Decompiled with CFR 0.152.
 */
package me.ledge.link.api.vos.datapoints;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.ledge.link.api.vos.datapoints.Custodian;
import me.ledge.link.api.vos.datapoints.FinancialAccountVo;

public class Card
extends FinancialAccountVo {
    @SerializedName(value="card_network")
    public CardNetwork cardNetwork;
    @SerializedName(value="last_four")
    public String lastFourDigits;
    @SerializedName(value="card_brand")
    public String cardBrand;
    @SerializedName(value="card_issuer")
    public String cardIssuer;
    @SerializedName(value="balance")
    public String balance;
    @SerializedName(value="pan")
    public String PANToken;
    @SerializedName(value="cvv")
    public String CVVToken;
    @SerializedName(value="expiration")
    public String expirationDate;
    @SerializedName(value="state")
    public FinancialAccountState state;
    public Custodian custodian;

    public Card() {
        super(null, FinancialAccountVo.FinancialAccountType.Card, false);
        this.cardNetwork = null;
        this.lastFourDigits = null;
        this.cardBrand = null;
        this.cardIssuer = null;
        this.balance = null;
        this.PANToken = null;
        this.CVVToken = null;
        this.expirationDate = null;
        this.state = null;
        this.custodian = null;
    }

    public Card(String accountId, String lastFourDigits, CardNetwork type, String cardBrand, String cardIssuer, String expirationDate, String PANToken, String CVVToken, FinancialAccountState state, String balance, Custodian custodian, boolean verified) {
        super(accountId, FinancialAccountVo.FinancialAccountType.Card, verified);
        this.cardNetwork = type;
        this.lastFourDigits = lastFourDigits;
        this.cardBrand = cardBrand;
        this.cardIssuer = cardIssuer;
        this.balance = balance;
        this.PANToken = PANToken;
        this.CVVToken = CVVToken;
        this.expirationDate = expirationDate;
        this.state = state;
        this.custodian = custodian;
    }

    protected Card(FinancialAccountVo.FinancialAccountType accountType, String accountId, String lastFourDigits, CardNetwork type, String cardBrand, String cardIssuer, String expirationDate, String PANToken, String CVVToken, FinancialAccountState state, String balance, Custodian custodian, boolean verified) {
        super(accountId, accountType, verified);
        this.cardNetwork = type;
        this.lastFourDigits = lastFourDigits;
        this.cardBrand = cardBrand;
        this.cardIssuer = cardIssuer;
        this.state = state;
        this.balance = balance;
        this.PANToken = PANToken;
        this.CVVToken = CVVToken;
        this.expirationDate = expirationDate;
        this.state = state;
        this.custodian = custodian;
    }

    public Card(Card c) {
        super(c.mAccountId, FinancialAccountVo.FinancialAccountType.Card, c.isVerified());
        this.cardNetwork = c.cardNetwork;
        this.lastFourDigits = c.lastFourDigits;
        this.cardBrand = c.cardBrand;
        this.cardIssuer = c.cardIssuer;
        this.state = c.state;
        this.balance = c.balance;
        this.PANToken = c.PANToken;
        this.CVVToken = c.CVVToken;
        this.expirationDate = c.expirationDate;
        this.state = c.state;
        this.custodian = c.custodian;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject gsonObject = super.toJSON();
        gsonObject.addProperty("type", "card");
        gsonObject.addProperty("card_network", this.cardNetwork.name());
        gsonObject.addProperty("card_brand", this.cardBrand);
        gsonObject.addProperty("card_issuer", this.cardIssuer);
        gsonObject.addProperty("state", this.state.name().toLowerCase());
        gsonObject.addProperty("balance", this.balance);
        gsonObject.addProperty("pan", this.PANToken);
        gsonObject.addProperty("cvv", this.CVVToken);
        gsonObject.addProperty("last_four", this.lastFourDigits);
        gsonObject.addProperty("expiration", this.getAPIFormatExpirationDate(this.expirationDate));
        return gsonObject;
    }

    private String getAPIFormatExpirationDate(String expirationDate) {
        String formattedExpirationDate;
        String CARD_EXPIRATION_FORMAT = "MM/yy";
        String API_FORMAT = "yyyy-MM";
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yy");
        try {
            Date date = dateFormat.parse(expirationDate);
            dateFormat.applyPattern("yyyy-MM");
            formattedExpirationDate = dateFormat.format(date);
        }
        catch (ParseException e) {
            formattedExpirationDate = null;
        }
        return formattedExpirationDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Card card = (Card)o;
        if (this.cardNetwork != card.cardNetwork) {
            return false;
        }
        if (this.lastFourDigits != null ? !this.lastFourDigits.equals(card.lastFourDigits) : card.lastFourDigits != null) {
            return false;
        }
        if (this.PANToken != null ? !this.PANToken.equals(card.PANToken) : card.PANToken != null) {
            return false;
        }
        if (this.CVVToken != null ? !this.CVVToken.equals(card.CVVToken) : card.CVVToken != null) {
            return false;
        }
        if (this.cardNetwork != null ? !this.cardNetwork.equals((Object)card.cardNetwork) : card.cardNetwork != null) {
            return false;
        }
        if (this.cardBrand != null ? !this.cardBrand.equals(card.cardBrand) : card.cardBrand != null) {
            return false;
        }
        if (this.cardIssuer != null ? !this.cardIssuer.equals(card.cardIssuer) : card.cardIssuer != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals((Object)card.state) : card.state != null) {
            return false;
        }
        if (this.balance != null ? !this.balance.equals(card.balance) : card.balance != null) {
            return false;
        }
        return this.expirationDate != null ? this.expirationDate.equals(card.expirationDate) : card.expirationDate == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() + (this.cardNetwork != null ? this.cardNetwork.hashCode() : 0);
        result = 31 * result + (this.lastFourDigits != null ? this.lastFourDigits.hashCode() : 0);
        result = 31 * result + (this.PANToken != null ? this.PANToken.hashCode() : 0);
        result = 31 * result + (this.CVVToken != null ? this.CVVToken.hashCode() : 0);
        result = 31 * result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
        result = 31 * result + (this.cardNetwork != null ? this.cardNetwork.hashCode() : 0);
        result = 31 * result + (this.cardBrand != null ? this.cardBrand.hashCode() : 0);
        result = 31 * result + (this.cardIssuer != null ? this.cardIssuer.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.balance != null ? this.balance.hashCode() : 0);
        return result;
    }

    public static enum FinancialAccountState {
        ACTIVE,
        INACTIVE,
        CANCELLED,
        CREATED,
        UNKNOWN;

    }

    public static enum CardNetwork {
        VISA,
        MASTERCARD,
        AMEX;

    }
}

