/*
 * Decompiled with CFR 0.152.
 */
package me.ledge.link.api.vos.datapoints;

import com.google.gson.JsonObject;
import me.ledge.link.api.vos.datapoints.DataPointVo;

public class Address
extends DataPointVo {
    public String address;
    public String apUnit;
    public String country;
    public String city;
    public String stateCode;
    public String zip;

    public Address() {
        this(null, null, null, null, null, null, false, false);
    }

    public Address(String address, String apUnit, String country, String city, String stateCode, String zip, boolean verified, boolean notSpecified) {
        super(DataPointVo.DataPointType.Address, verified, notSpecified);
        this.address = address;
        this.apUnit = apUnit;
        this.country = country;
        this.city = city;
        this.stateCode = stateCode;
        this.zip = zip;
    }

    public void update(Address addressToCopy) {
        this.address = addressToCopy.address;
        this.apUnit = addressToCopy.apUnit;
        this.country = addressToCopy.country;
        this.city = addressToCopy.city;
        this.stateCode = addressToCopy.stateCode;
        this.zip = addressToCopy.zip;
    }

    public String addressDescription() {
        if ("US".equalsIgnoreCase(this.country)) {
            String retVal = "";
            if (this.address != null) {
                retVal = retVal + this.address;
            }
            if (this.city != null) {
                retVal = retVal + ", " + this.city;
            }
            if (this.stateCode != null) {
                retVal = retVal + ", " + this.stateCode;
            }
            if (this.zip != null) {
                retVal = retVal + ", " + this.zip;
            }
            return retVal;
        }
        return null;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject gsonObject = super.toJSON();
        gsonObject.addProperty("data_type", "address");
        gsonObject.addProperty("address", this.address);
        gsonObject.addProperty("apt", this.apUnit);
        gsonObject.addProperty("city", this.city);
        gsonObject.addProperty("state", this.stateCode);
        gsonObject.addProperty("zip", this.zip);
        return gsonObject;
    }

    public String toString() {
        return this.addressDescription();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Address address1 = (Address)o;
        if (this.address != null ? !this.address.equals(address1.address) : address1.address != null) {
            return false;
        }
        if (this.apUnit != null ? !this.apUnit.equals(address1.apUnit) : address1.apUnit != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(address1.country) : address1.country != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(address1.city) : address1.city != null) {
            return false;
        }
        if (this.stateCode != null ? !this.stateCode.equals(address1.stateCode) : address1.stateCode != null) {
            return false;
        }
        return this.zip != null ? this.zip.equals(address1.zip) : address1.zip == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.apUnit != null ? this.apUnit.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 31 * result + (this.stateCode != null ? this.stateCode.hashCode() : 0);
        result = 31 * result + (this.zip != null ? this.zip.hashCode() : 0);
        return result;
    }
}

