/*
 * Decompiled with CFR 0.152.
 */
package me.ledge.link.api.vos.datapoints;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import me.ledge.link.api.vos.datapoints.DataPointVo;

public class FinancialAccountVo
extends DataPointVo {
    @SerializedName(value="account_id")
    public String mAccountId;
    @SerializedName(value="account_type")
    public FinancialAccountType mAccountType;

    public FinancialAccountVo(String accountId, FinancialAccountType type, boolean verified) {
        super(DataPointVo.DataPointType.FinancialAccount, verified, false);
        this.mAccountId = accountId;
        this.mAccountType = type;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject gsonObject = super.toJSON();
        if (this.isAccountIdPresent()) {
            gsonObject.addProperty("account_id", this.mAccountId);
        }
        gsonObject.addProperty("account_type", this.mAccountType.name());
        return gsonObject;
    }

    private boolean isAccountIdPresent() {
        return this.mAccountId != null && !this.mAccountId.equals("");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FinancialAccountVo that = (FinancialAccountVo)o;
        if (this.mAccountId != null ? !this.mAccountId.equals(that.mAccountId) : that.mAccountId != null) {
            return false;
        }
        return this.mAccountType == that.mAccountType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() + (this.mAccountId != null ? this.mAccountId.hashCode() : 0);
        result = 31 * result + (this.mAccountType != null ? this.mAccountType.hashCode() : 0);
        return result;
    }

    public static enum FinancialAccountType {
        Bank,
        Card,
        VirtualCard;

    }
}

