/*
 * Decompiled with CFR 0.152.
 */
package me.julb.maven.plugins;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class AWSLambdaBootstrapGenerate
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="runtimeFileName", required=true, defaultValue="${project.artifactId}")
    String runtimeFileName;
    @Parameter(property="runtimeOptions")
    String runtimeOptions;
    @Parameter(property="outputFile", required=true, defaultValue="${project.build.directory}/aws-lambda/bootstrap")
    String outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().debug((CharSequence)String.format("runtime file name: %s", this.runtimeFileName));
            this.getLog().debug((CharSequence)String.format("runtime options: %s", this.runtimeOptions));
            this.getLog().debug((CharSequence)String.format("bootstrap output file: %s", this.outputFile));
            if (this.runtimeFileName == null || this.runtimeFileName.trim().isEmpty()) {
                throw new IllegalArgumentException("runtimeFileName is required.");
            }
            if (this.outputFile == null || this.outputFile.trim().isEmpty()) {
                throw new IllegalArgumentException("outputFile is required.");
            }
            Path outputFilePath = Path.of(this.outputFile, new String[0]);
            this.getLog().debug((CharSequence)"creating output directory.");
            outputFilePath.getParent().toFile().mkdirs();
            this.getLog().debug((CharSequence)"write bootstrap content.");
            String runtimeExec = String.format("./%s", this.runtimeFileName);
            if (this.runtimeOptions != null) {
                runtimeExec = runtimeExec + " " + this.runtimeOptions;
            }
            List<String> lines = Arrays.asList("#!/bin/sh", "", "cd $LAMBDA_TASK_ROOT", "", runtimeExec);
            Files.write(outputFilePath, lines, StandardCharsets.UTF_8, new OpenOption[0]);
            this.getLog().debug((CharSequence)"setting file permissions to 0755.");
            EnumSet<PosixFilePermission[]> permissions = EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE});
            Files.setPosixFilePermissions(outputFilePath, permissions);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to generate bootstrap file.", (Throwable)e);
            throw new MojoExecutionException((Throwable)e);
        }
    }
}

