/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.androidutils;

import android.content.Context;
import android.content.res.Resources;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0003\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\n\u00a8\u0006\f"}, d2={"dpToPx", "", "dp", "", "pxToDp", "pixels", "pxToSp", "spToPx", "sp", "getNavigationBarHeight", "Landroid/content/Context;", "getStatusBarHeight", "androidutils_release"})
public final class DimenUtilsKt {
    public static final int getStatusBarHeight(@NotNull Context $this$getStatusBarHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$getStatusBarHeight, (String)"$this$getStatusBarHeight");
        int resId = $this$getStatusBarHeight.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return resId > 0 ? $this$getStatusBarHeight.getResources().getDimensionPixelSize(resId) : 0;
    }

    public static final int getNavigationBarHeight(@NotNull Context $this$getNavigationBarHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$getNavigationBarHeight, (String)"$this$getNavigationBarHeight");
        int resId = $this$getNavigationBarHeight.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        return resId > 0 ? $this$getNavigationBarHeight.getResources().getDimensionPixelSize(resId) : 0;
    }

    public static final int dpToPx(float dp) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        return (int)(resources.getDisplayMetrics().density * dp);
    }

    public static final float pxToDp(int pixels) {
        float f = pixels;
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        return f / resources.getDisplayMetrics().density;
    }

    public static final int spToPx(float sp) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        return (int)(resources.getDisplayMetrics().scaledDensity * sp);
    }

    public static final float pxToSp(int pixels) {
        float f = pixels;
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        return f / resources.getDisplayMetrics().scaledDensity;
    }
}

