/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.androidutils;

import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.Window;
import androidx.annotation.ColorInt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006\u001a\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u0001\u001a\n\u0010\u001c\u001a\u00020\u001b*\u00020\u0001\u001a\u0016\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\n\u0010\u001e\u001a\u00020\u0011\"\u00020\u0001\u001a \u0010\u001f\u001a\u00020\u0001*\u00020\u00012\n\u0010\u001e\u001a\u00020\u0011\"\u00020\u00012\b\b\u0002\u0010 \u001a\u00020\u0001\u001a2\u0010!\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\"\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\""}, d2={"ALPHA_CHANNEL", "", "BLUE_CHANNEL", "GREEN_CHANNEL", "RED_CHANNEL", "alpha", "", "getAlpha", "(I)F", "blue", "getBlue", "(I)I", "green", "getGreen", "red", "getRed", "createColorWheelArray", "", "saturation", "brightness", "getColorDarkness", "", "color", "autoSystemUiColors", "", "Landroid/view/Window;", "isColorDark", "", "isColorLight", "mixColor", "colors", "multiplyColor", "base", "setColor", "androidutils_release"})
public final class ColorUtilsKt {
    private static final int ALPHA_CHANNEL = 24;
    private static final int RED_CHANNEL = 16;
    private static final int GREEN_CHANNEL = 8;
    private static final int BLUE_CHANNEL = 0;

    public static final int getRed(int $this$red) {
        return $this$red >> 16 & 0xFF;
    }

    public static final int getGreen(int $this$green) {
        return $this$green >> 8 & 0xFF;
    }

    public static final int getBlue(int $this$blue) {
        return $this$blue >> 0 & 0xFF;
    }

    public static final float getAlpha(int $this$alpha) {
        return (float)($this$alpha >> 24 & 0xFF) / 255.0f;
    }

    public static final int setColor(int $this$setColor, int red, int green, int blue, float alpha) {
        return Color.argb((int)((int)(alpha * (float)255)), (int)red, (int)green, (int)blue);
    }

    public static /* synthetic */ int setColor$default(int n, int n2, int n3, int n4, float f, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n2 = ColorUtilsKt.getRed(n);
        }
        if ((n5 & 2) != 0) {
            n3 = ColorUtilsKt.getGreen(n);
        }
        if ((n5 & 4) != 0) {
            n4 = ColorUtilsKt.getBlue(n);
        }
        if ((n5 & 8) != 0) {
            f = ColorUtilsKt.getAlpha(n);
        }
        return ColorUtilsKt.setColor(n, n2, n3, n4, f);
    }

    public static final int mixColor(int $this$mixColor, int ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        int r = ColorUtilsKt.getRed($this$mixColor);
        int g = ColorUtilsKt.getGreen($this$mixColor);
        int b = ColorUtilsKt.getBlue($this$mixColor);
        float a = ColorUtilsKt.getAlpha($this$mixColor);
        for (int color : colors) {
            r += (int)((float)ColorUtilsKt.getRed(color) * ColorUtilsKt.getAlpha(color));
            g += (int)((float)ColorUtilsKt.getGreen(color) * ColorUtilsKt.getAlpha(color));
            b += (int)((float)ColorUtilsKt.getBlue(color) * ColorUtilsKt.getAlpha(color));
            a += ColorUtilsKt.getAlpha(color);
        }
        return Color.argb((int)((int)(a / (float)(colors.length + 1) * (float)255)), (int)RangesKt.coerceIn((int)((int)((float)r / a)), (int)0, (int)255), (int)RangesKt.coerceIn((int)((int)((float)g / a)), (int)0, (int)255), (int)RangesKt.coerceIn((int)((int)((float)b / a)), (int)0, (int)255));
    }

    public static final int multiplyColor(int $this$multiplyColor, @NotNull int[] colors, int base) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        int mixer = ColorUtilsKt.mixColor(base, Arrays.copyOf(colors, colors.length));
        return Color.rgb((int)RangesKt.coerceIn((int)(ColorUtilsKt.getRed($this$multiplyColor) * ColorUtilsKt.getRed(mixer) / 255), (int)0, (int)255), (int)RangesKt.coerceIn((int)(ColorUtilsKt.getGreen($this$multiplyColor) * ColorUtilsKt.getGreen(mixer) / 255), (int)0, (int)255), (int)RangesKt.coerceIn((int)(ColorUtilsKt.getBlue($this$multiplyColor) * ColorUtilsKt.getBlue(mixer) / 255), (int)0, (int)255));
    }

    public static /* synthetic */ int multiplyColor$default(int n, int[] nArray, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return ColorUtilsKt.multiplyColor(n, nArray, n2);
    }

    public static final boolean isColorDark(int $this$isColorDark) {
        return ColorUtilsKt.getColorDarkness($this$isColorDark) >= 0.5;
    }

    public static final boolean isColorLight(int $this$isColorLight) {
        return !ColorUtilsKt.isColorDark($this$isColorLight);
    }

    private static final double getColorDarkness(@ColorInt int color) {
        if (color == -16777216) {
            return 1.0;
        }
        if (color == -1 || color == 0) {
            return 0.0;
        }
        return 1.0 - (0.259 * (double)Color.red((int)color) + 0.667 * (double)Color.green((int)color) + 0.074 * (double)Color.blue((int)color)) / (double)255;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final int[] createColorWheelArray(float saturation, float brightness) {
        int[] arr = new int[13];
        int n = 0;
        int n2 = 12;
        while (n <= n2) {
            void i;
            arr[i] = Color.HSVToColor((float[])new float[]{(float)i * (float)30, saturation, brightness});
            ++i;
        }
        return arr;
    }

    public static final void autoSystemUiColors(@NotNull Window $this$autoSystemUiColors) {
        Intrinsics.checkNotNullParameter((Object)$this$autoSystemUiColors, (String)"$this$autoSystemUiColors");
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (ColorUtilsKt.isColorLight($this$autoSystemUiColors.getStatusBarColor())) {
            if (Build.VERSION.SDK_INT >= 23) {
                View view = $this$autoSystemUiColors.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"decorView");
                View view2 = $this$autoSystemUiColors.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"decorView");
                view.setSystemUiVisibility(view2.getSystemUiVisibility() | 0x2000);
            } else if (Build.VERSION.SDK_INT >= 21) {
                $this$autoSystemUiColors.setStatusBarColor(-16777216);
            }
        }
        if (ColorUtilsKt.isColorLight($this$autoSystemUiColors.getNavigationBarColor())) {
            if (Build.VERSION.SDK_INT >= 26) {
                View view = $this$autoSystemUiColors.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"decorView");
                View view3 = $this$autoSystemUiColors.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"decorView");
                view.setSystemUiVisibility(view3.getSystemUiVisibility() | 0x10);
            } else if (Build.VERSION.SDK_INT >= 21) {
                $this$autoSystemUiColors.setNavigationBarColor(-16777216);
            }
        }
    }
}

