/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.androidutils.seekbar;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import me.jfenn.androidutils.DimenUtilsKt;

public class SeekBarBackgroundDrawable
extends Drawable {
    private Drawable drawable;
    private float height;
    private Paint paint;

    public SeekBarBackgroundDrawable(Drawable drawable) {
        this.drawable = drawable;
        this.height = DimenUtilsKt.dpToPx(2.0f);
        this.paint = new Paint();
    }

    public void draw(@NonNull Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        this.drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        this.drawable.draw(new Canvas(bitmap));
        Rect bounds = this.getBounds();
        canvas.clipRect(new Rect(bounds.left, (int)((float)bounds.centerY() - this.height / 2.0f), bounds.right, (int)((float)bounds.centerY() + this.height / 2.0f)));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.paint);
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -2;
    }
}

