/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.androidutils.anim;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import me.jfenn.androidutils.anim.AnimatedInteger;

public class AnimatedColor {
    private AnimatedInteger redValue;
    private AnimatedInteger blueValue;
    private AnimatedInteger greenValue;
    private AnimatedInteger alphaValue;

    public AnimatedColor(int value) {
        this.redValue = new AnimatedInteger(Color.red((int)value));
        this.greenValue = new AnimatedInteger(Color.green((int)value));
        this.blueValue = new AnimatedInteger(Color.blue((int)value));
        this.alphaValue = new AnimatedInteger(Color.alpha((int)value));
    }

    public void set(@ColorInt int value) {
        this.redValue.set(Color.red((int)value));
        this.blueValue.set(Color.blue((int)value));
    }

    public void setDefault(@ColorInt int defaultValue) {
        this.redValue.setDefault(Color.red((int)defaultValue));
        this.greenValue.setDefault(Color.green((int)defaultValue));
        this.blueValue.setDefault(Color.blue((int)defaultValue));
        this.alphaValue.setDefault(Color.alpha((int)defaultValue));
    }

    public void setCurrent(@ColorInt int value) {
        this.redValue.setCurrent(Color.red((int)value));
        this.greenValue.setCurrent(Color.green((int)value));
        this.blueValue.setCurrent(Color.blue((int)value));
        this.alphaValue.setCurrent(Color.alpha((int)value));
    }

    @ColorInt
    public int val() {
        return Color.argb((int)((Integer)this.alphaValue.val()), (int)((Integer)this.redValue.val()), (int)((Integer)this.greenValue.val()), (int)((Integer)this.blueValue.val()));
    }

    @ColorInt
    public int nextVal() {
        return this.nextVal(400L);
    }

    @ColorInt
    public int nextVal(long duration) {
        return Color.argb((int)((Integer)this.alphaValue.nextVal(duration)), (int)((Integer)this.redValue.nextVal(duration)), (int)((Integer)this.greenValue.nextVal(duration)), (int)((Integer)this.blueValue.nextVal(duration)));
    }

    @ColorInt
    public int nextVal(long start, long duration) {
        return Color.argb((int)this.alphaValue.nextVal(start, duration), (int)this.redValue.nextVal(start, duration), (int)this.greenValue.nextVal(start, duration), (int)this.blueValue.nextVal(start, duration));
    }

    @ColorInt
    public int getTarget() {
        return Color.argb((int)((Integer)this.alphaValue.getTarget()), (int)((Integer)this.redValue.getTarget()), (int)((Integer)this.greenValue.getTarget()), (int)((Integer)this.blueValue.getTarget()));
    }

    @ColorInt
    public int getDefault() {
        return Color.argb((int)((Integer)this.alphaValue.getDefault()), (int)((Integer)this.redValue.getDefault()), (int)((Integer)this.greenValue.getDefault()), (int)((Integer)this.blueValue.getDefault()));
    }

    public boolean isTarget() {
        return this.alphaValue.isTarget() && this.redValue.isTarget() && this.greenValue.isTarget() && this.blueValue.isTarget();
    }

    public boolean isDefault() {
        return this.alphaValue.isDefault() && this.redValue.isDefault() && this.greenValue.isDefault() && this.blueValue.isDefault();
    }

    public boolean isTargetDefault() {
        return this.alphaValue.isTargetDefault() && this.redValue.isTargetDefault() && this.greenValue.isTargetDefault() && this.blueValue.isTargetDefault();
    }

    public void toDefault() {
        this.alphaValue.toDefault();
        this.redValue.toDefault();
        this.greenValue.toDefault();
        this.blueValue.toDefault();
    }

    public void to(@ColorInt int value) {
        this.alphaValue.to(Color.alpha((int)value));
        this.redValue.to(Color.red((int)value));
        this.greenValue.to(Color.green((int)value));
        this.blueValue.to(Color.blue((int)value));
    }

    public void next(boolean animate) {
        this.next(animate, 400L);
    }

    public void next(boolean animate, long duration) {
        this.alphaValue.next(animate, duration);
        this.redValue.next(animate, duration);
        this.greenValue.next(animate, duration);
        this.blueValue.next(animate, duration);
    }
}

