/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.androidutils;

import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.Window;
import androidx.annotation.ColorInt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u0012\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u0001H\u0002\u001a\n\u0010\r\u001a\u00020\b*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0014*\u00020\u0001\u001a\u0016\u0010\u0016\u001a\u00020\u0001*\u00020\u00012\n\u0010\u0017\u001a\u00020\u0006\"\u00020\u0001\u001a \u0010\u0018\u001a\u00020\u0001*\u00020\u00012\n\u0010\u0017\u001a\u00020\u0006\"\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0001\u001a2\u0010\u001b\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u001a\u001a\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u0011\u001a\u00020\u00012\b\b\u0002\u0010\r\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"ALPHA_CHANNEL", "", "BLUE_CHANNEL", "GREEN_CHANNEL", "RED_CHANNEL", "createColorWheelArray", "", "saturation", "", "brightness", "getColorDarkness", "", "color", "alpha", "autoSystemUiColors", "", "Landroid/view/Window;", "blue", "green", "isColorDark", "", "isColorLight", "mixColor", "colors", "multiplyColor", "base", "red", "setColor", "androidutils_release"})
public final class ColorUtilsKt {
    private static final int ALPHA_CHANNEL = 24;
    private static final int RED_CHANNEL = 16;
    private static final int GREEN_CHANNEL = 8;
    private static final int BLUE_CHANNEL = 0;

    public static final int red(int $this$red) {
        return $this$red >> 16 & 0xFF;
    }

    public static final int green(int $this$green) {
        return $this$green >> 8 & 0xFF;
    }

    public static final int blue(int $this$blue) {
        return $this$blue >> 0 & 0xFF;
    }

    public static final float alpha(int $this$alpha) {
        return (float)($this$alpha >> 24 & 0xFF) / 255.0f;
    }

    public static final int setColor(int $this$setColor, int red, int green, int blue, float alpha) {
        return Color.argb((int)((int)(alpha * (float)255)), (int)red, (int)green, (int)blue);
    }

    public static /* synthetic */ int setColor$default(int n, int n2, int n3, int n4, float f, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n2 = ColorUtilsKt.red(n);
        }
        if ((n5 & 2) != 0) {
            n3 = ColorUtilsKt.green(n);
        }
        if ((n5 & 4) != 0) {
            n4 = ColorUtilsKt.blue(n);
        }
        if ((n5 & 8) != 0) {
            f = ColorUtilsKt.alpha(n);
        }
        return ColorUtilsKt.setColor(n, n2, n3, n4, f);
    }

    public static final int mixColor(int $this$mixColor, int ... colors) {
        Intrinsics.checkParameterIsNotNull((Object)colors, (String)"colors");
        int red = ColorUtilsKt.red($this$mixColor);
        int green = ColorUtilsKt.green($this$mixColor);
        int blue = ColorUtilsKt.blue($this$mixColor);
        float alpha = ColorUtilsKt.alpha($this$mixColor);
        for (int color : colors) {
            red += (int)((float)ColorUtilsKt.red(color) * ColorUtilsKt.alpha(color));
            green += (int)((float)ColorUtilsKt.green(color) * ColorUtilsKt.alpha(color));
            blue += (int)((float)ColorUtilsKt.blue(color) * ColorUtilsKt.alpha(color));
            alpha += ColorUtilsKt.alpha(color);
        }
        return Color.argb((int)((int)(alpha / (float)(colors.length + 1) * (float)255)), (int)RangesKt.coerceIn((int)((int)((float)red / alpha)), (int)0, (int)255), (int)RangesKt.coerceIn((int)((int)((float)green / alpha)), (int)0, (int)255), (int)RangesKt.coerceIn((int)((int)((float)blue / alpha)), (int)0, (int)255));
    }

    public static final int multiplyColor(int $this$multiplyColor, @NotNull int[] colors, int base) {
        Intrinsics.checkParameterIsNotNull((Object)colors, (String)"colors");
        int mixer = ColorUtilsKt.mixColor(base, Arrays.copyOf(colors, colors.length));
        return Color.rgb((int)RangesKt.coerceIn((int)(ColorUtilsKt.red($this$multiplyColor) * ColorUtilsKt.red(mixer) / 255), (int)0, (int)255), (int)RangesKt.coerceIn((int)(ColorUtilsKt.green($this$multiplyColor) * ColorUtilsKt.green(mixer) / 255), (int)0, (int)255), (int)RangesKt.coerceIn((int)(ColorUtilsKt.blue($this$multiplyColor) * ColorUtilsKt.blue(mixer) / 255), (int)0, (int)255));
    }

    public static /* synthetic */ int multiplyColor$default(int n, int[] nArray, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return ColorUtilsKt.multiplyColor(n, nArray, n2);
    }

    public static final boolean isColorDark(int $this$isColorDark) {
        return ColorUtilsKt.getColorDarkness($this$isColorDark) >= 0.5;
    }

    public static final boolean isColorLight(int $this$isColorLight) {
        return !ColorUtilsKt.isColorDark($this$isColorLight);
    }

    private static final double getColorDarkness(@ColorInt int color) {
        if (color == -16777216) {
            return 1.0;
        }
        if (color == -1 || color == 0) {
            return 0.0;
        }
        return 1.0 - (0.259 * (double)Color.red((int)color) + 0.667 * (double)Color.green((int)color) + 0.074 * (double)Color.blue((int)color)) / (double)255;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final int[] createColorWheelArray(float saturation, float brightness) {
        int[] arr = new int[13];
        int n = 0;
        int n2 = 12;
        while (n <= n2) {
            void i;
            arr[i] = Color.HSVToColor((float[])new float[]{(float)i * (float)30, saturation, brightness});
            ++i;
        }
        return arr;
    }

    public static final void autoSystemUiColors(@NotNull Window $this$autoSystemUiColors) {
        Intrinsics.checkParameterIsNotNull((Object)$this$autoSystemUiColors, (String)"$this$autoSystemUiColors");
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (ColorUtilsKt.isColorLight($this$autoSystemUiColors.getStatusBarColor())) {
            if (Build.VERSION.SDK_INT >= 23) {
                View view = $this$autoSystemUiColors.getDecorView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"decorView");
                View view2 = $this$autoSystemUiColors.getDecorView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"decorView");
                view.setSystemUiVisibility(view2.getSystemUiVisibility() | 0x2000);
            } else if (Build.VERSION.SDK_INT >= 21) {
                $this$autoSystemUiColors.setStatusBarColor(-16777216);
            }
        }
        if (ColorUtilsKt.isColorLight($this$autoSystemUiColors.getNavigationBarColor())) {
            if (Build.VERSION.SDK_INT >= 26) {
                View view = $this$autoSystemUiColors.getDecorView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"decorView");
                View view3 = $this$autoSystemUiColors.getDecorView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"decorView");
                view.setSystemUiVisibility(view3.getSystemUiVisibility() | 0x10);
            } else if (Build.VERSION.SDK_INT >= 21) {
                $this$autoSystemUiColors.setNavigationBarColor(-16777216);
            }
        }
    }
}

