/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.progressmanager.body;

import android.os.Handler;
import android.os.SystemClock;
import java.io.IOException;
import java.util.List;
import me.jessyan.progressmanager.ProgressListener;
import me.jessyan.progressmanager.body.ProgressInfo;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class ProgressResponseBody
extends ResponseBody {
    protected Handler mHandler;
    protected int mRefreshTime;
    protected final ResponseBody mDelegate;
    protected final ProgressListener[] mListeners;
    protected final ProgressInfo mProgressInfo;
    private BufferedSource mBufferedSource;

    public ProgressResponseBody(Handler handler, ResponseBody responseBody, List<ProgressListener> listeners, int refreshTime) {
        this.mDelegate = responseBody;
        this.mListeners = listeners.toArray(new ProgressListener[listeners.size()]);
        this.mHandler = handler;
        this.mRefreshTime = refreshTime;
        this.mProgressInfo = new ProgressInfo(System.currentTimeMillis());
    }

    public MediaType contentType() {
        return this.mDelegate.contentType();
    }

    public long contentLength() {
        return this.mDelegate.contentLength();
    }

    public BufferedSource source() {
        if (this.mBufferedSource == null) {
            this.mBufferedSource = Okio.buffer((Source)this.source((Source)this.mDelegate.source()));
        }
        return this.mBufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            private long totalBytesRead;
            private long lastRefreshTime;
            private long tempSize;
            {
                this.totalBytesRead = 0L;
                this.lastRefreshTime = 0L;
                this.tempSize = 0L;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long curTime;
                long bytesRead = 0L;
                try {
                    bytesRead = super.read(sink, byteCount);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    for (int i = 0; i < ProgressResponseBody.this.mListeners.length; ++i) {
                        ProgressResponseBody.this.mListeners[i].onError(ProgressResponseBody.this.mProgressInfo.getId(), e);
                    }
                    throw e;
                }
                if (ProgressResponseBody.this.mProgressInfo.getContentLength() == 0L) {
                    ProgressResponseBody.this.mProgressInfo.setContentLength(ProgressResponseBody.this.contentLength());
                }
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                this.tempSize += bytesRead != -1L ? bytesRead : 0L;
                if (ProgressResponseBody.this.mListeners != null && ((curTime = SystemClock.elapsedRealtime()) - this.lastRefreshTime >= (long)ProgressResponseBody.this.mRefreshTime || bytesRead == -1L || this.totalBytesRead == ProgressResponseBody.this.mProgressInfo.getContentLength())) {
                    final long finalBytesRead = bytesRead;
                    final long finalTempSize = this.tempSize;
                    final long finalTotalBytesRead = this.totalBytesRead;
                    final long finalIntervalTime = curTime - this.lastRefreshTime;
                    for (int i = 0; i < ProgressResponseBody.this.mListeners.length; ++i) {
                        final ProgressListener listener = ProgressResponseBody.this.mListeners[i];
                        ProgressResponseBody.this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                ProgressResponseBody.this.mProgressInfo.setEachBytes(finalBytesRead != -1L ? finalTempSize : -1L);
                                ProgressResponseBody.this.mProgressInfo.setCurrentbytes(finalTotalBytesRead);
                                ProgressResponseBody.this.mProgressInfo.setIntervalTime(finalIntervalTime);
                                ProgressResponseBody.this.mProgressInfo.setFinish(finalBytesRead == -1L && finalTotalBytesRead == ProgressResponseBody.this.mProgressInfo.getContentLength());
                                listener.onProgress(ProgressResponseBody.this.mProgressInfo);
                            }
                        });
                    }
                    this.lastRefreshTime = curTime;
                    this.tempSize = 0L;
                }
                return bytesRead;
            }
        };
    }
}

