/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.progressmanager;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import me.jessyan.progressmanager.ProgressListener;
import me.jessyan.progressmanager.body.ProgressRequestBody;
import me.jessyan.progressmanager.body.ProgressResponseBody;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class ProgressManager {
    private final Map<String, List<ProgressListener>> mRequestListeners = new WeakHashMap<String, List<ProgressListener>>();
    private final Map<String, List<ProgressListener>> mResponseListeners = new WeakHashMap<String, List<ProgressListener>>();
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Interceptor mInterceptor = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            return ProgressManager.this.wrapResponseBody(chain.proceed(ProgressManager.this.wrapRequestBody(chain.request())));
        }
    };
    private int mRefreshTime = 150;
    private static volatile ProgressManager mProgressManager;
    public static final String OKHTTP_PACKAGE_NAME = "okhttp3.OkHttpClient";
    public static final boolean DEPENDENCY_OKHTTP;
    public static final int DEFAULT_REFRESH_TIME = 150;
    public static final String IDENTIFICATION_NUMBER = "?JessYan=";
    public static final String IDENTIFICATION_HEADER = "JessYan";
    public static final String LOCATION_HEADER = "Location";

    private ProgressManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ProgressManager getInstance() {
        if (mProgressManager != null) return mProgressManager;
        if (!DEPENDENCY_OKHTTP) {
            throw new IllegalStateException("Must be dependency Okhttp");
        }
        Class<ProgressManager> clazz = ProgressManager.class;
        synchronized (ProgressManager.class) {
            if (mProgressManager != null) return mProgressManager;
            mProgressManager = new ProgressManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mProgressManager;
        }
    }

    public void setRefreshTime(int refreshTime) {
        this.mRefreshTime = refreshTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestListener(String url, ProgressListener listener) {
        Class<ProgressManager> clazz = ProgressManager.class;
        synchronized (ProgressManager.class) {
            List<ProgressListener> progressListeners = this.mRequestListeners.get(url);
            if (progressListeners == null) {
                progressListeners = new LinkedList<ProgressListener>();
                this.mRequestListeners.put(url, progressListeners);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            progressListeners.add(listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponseListener(String url, ProgressListener listener) {
        Class<ProgressManager> clazz = ProgressManager.class;
        synchronized (ProgressManager.class) {
            List<ProgressListener> progressListeners = this.mResponseListeners.get(url);
            if (progressListeners == null) {
                progressListeners = new LinkedList<ProgressListener>();
                this.mResponseListeners.put(url, progressListeners);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            progressListeners.add(listener);
            return;
        }
    }

    public void notifyOnErorr(String url, Exception e) {
        this.forEachListenersOnError(this.mRequestListeners, url, e);
        this.forEachListenersOnError(this.mResponseListeners, url, e);
    }

    public OkHttpClient.Builder with(OkHttpClient.Builder builder) {
        return builder.addNetworkInterceptor(this.mInterceptor);
    }

    public Request wrapRequestBody(Request request) {
        if (request == null) {
            return request;
        }
        String key = request.url().toString();
        if ((request = this.pruneIdentification(key, request)).body() == null) {
            return request;
        }
        if (this.mRequestListeners.containsKey(key)) {
            List<ProgressListener> listeners = this.mRequestListeners.get(key);
            return request.newBuilder().method(request.method(), (RequestBody)new ProgressRequestBody(this.mHandler, request.body(), listeners, this.mRefreshTime)).build();
        }
        return request;
    }

    private Request pruneIdentification(String url, Request request) {
        boolean needPrune = url.contains(IDENTIFICATION_NUMBER);
        if (!needPrune) {
            return request;
        }
        return request.newBuilder().url(url.substring(0, url.indexOf(IDENTIFICATION_NUMBER))).header(IDENTIFICATION_HEADER, url).build();
    }

    public Response wrapResponseBody(Response response) {
        if (response == null) {
            return response;
        }
        String key = response.request().url().toString();
        if (!TextUtils.isEmpty((CharSequence)response.request().header(IDENTIFICATION_HEADER))) {
            key = response.request().header(IDENTIFICATION_HEADER);
        }
        if (this.haveRedirect(response)) {
            this.resolveRedirect(this.mRequestListeners, response, key);
            String location = this.resolveRedirect(this.mResponseListeners, response, key);
            response = this.modifyLocation(response, location);
            return response;
        }
        if (response.body() == null) {
            return response;
        }
        if (this.mResponseListeners.containsKey(key)) {
            List<ProgressListener> listeners = this.mResponseListeners.get(key);
            return response.newBuilder().body((ResponseBody)new ProgressResponseBody(this.mHandler, response.body(), listeners, this.mRefreshTime)).build();
        }
        return response;
    }

    private Response modifyLocation(Response response, String location) {
        if (!TextUtils.isEmpty((CharSequence)location) && location.contains(IDENTIFICATION_NUMBER)) {
            response = response.newBuilder().header(LOCATION_HEADER, location).build();
        }
        return response;
    }

    public String addDiffResponseListenerOnSameUrl(String originUrl, ProgressListener listener) {
        return this.addDiffResponseListenerOnSameUrl(originUrl, String.valueOf(SystemClock.elapsedRealtime() + (long)listener.hashCode()), listener);
    }

    public String addDiffResponseListenerOnSameUrl(String originUrl, String key, ProgressListener listener) {
        String newUrl = originUrl + IDENTIFICATION_NUMBER + key;
        this.addResponseListener(newUrl, listener);
        return newUrl;
    }

    public String addDiffRequestListenerOnSameUrl(String originUrl, ProgressListener listener) {
        return this.addDiffRequestListenerOnSameUrl(originUrl, String.valueOf(SystemClock.elapsedRealtime() + (long)listener.hashCode()), listener);
    }

    public String addDiffRequestListenerOnSameUrl(String originUrl, String key, ProgressListener listener) {
        String newUrl = originUrl + IDENTIFICATION_NUMBER + key;
        this.addRequestListener(newUrl, listener);
        return newUrl;
    }

    private boolean haveRedirect(Response response) {
        String status = String.valueOf(response.code());
        if (TextUtils.isEmpty((CharSequence)status)) {
            return false;
        }
        return status.contains("301") || status.contains("302") || status.contains("303") || status.contains("307");
    }

    private String resolveRedirect(Map<String, List<ProgressListener>> map, Response response, String url) {
        String location = null;
        List<ProgressListener> progressListeners = map.get(url);
        if (progressListeners != null && progressListeners.size() > 0 && !TextUtils.isEmpty((CharSequence)(location = response.header(LOCATION_HEADER)))) {
            if (url.contains(IDENTIFICATION_NUMBER) && !location.contains(IDENTIFICATION_NUMBER)) {
                location = location + url.substring(url.indexOf(IDENTIFICATION_NUMBER), url.length());
            }
            if (!map.containsKey(location)) {
                map.put(location, progressListeners);
            } else {
                List<ProgressListener> locationListener = map.get(location);
                for (ProgressListener listener : progressListeners) {
                    if (locationListener.contains(listener)) continue;
                    locationListener.add(listener);
                }
            }
        }
        return location;
    }

    private void forEachListenersOnError(Map<String, List<ProgressListener>> map, String url, Exception e) {
        if (map.containsKey(url)) {
            List<ProgressListener> progressListeners = map.get(url);
            ProgressListener[] array = progressListeners.toArray(new ProgressListener[progressListeners.size()]);
            for (int i = 0; i < array.length; ++i) {
                array[i].onError(-1L, e);
            }
        }
    }

    static {
        boolean hasDependency;
        try {
            Class.forName(OKHTTP_PACKAGE_NAME);
            hasDependency = true;
        }
        catch (ClassNotFoundException e) {
            hasDependency = false;
        }
        DEPENDENCY_OKHTTP = hasDependency;
    }
}

