/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.server.http.server;

import android.util.Log;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.UsbFileInputStream;
import com.github.mjdev.libaums.server.http.UsbFileProvider;
import com.github.mjdev.libaums.server.http.exception.NotAFileException;
import com.github.mjdev.libaums.server.http.server.HttpServer;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.koushikdutta.async.http.server.AsyncHttpServerResponse;
import com.koushikdutta.async.http.server.HttpServerRequestCallback;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lcom/github/mjdev/libaums/server/http/server/AsyncHttpServer;", "Lcom/github/mjdev/libaums/server/http/server/HttpServer;", "Lcom/koushikdutta/async/http/server/HttpServerRequestCallback;", "port", "", "(I)V", "hostname", "", "getHostname", "()Ljava/lang/String;", "isAlive", "", "()Z", "setAlive", "(Z)V", "listeningPort", "getListeningPort", "()I", "server", "Lcom/koushikdutta/async/http/server/AsyncHttpServer;", "usbFileProvider", "Lcom/github/mjdev/libaums/server/http/UsbFileProvider;", "getUsbFileProvider", "()Lcom/github/mjdev/libaums/server/http/UsbFileProvider;", "setUsbFileProvider", "(Lcom/github/mjdev/libaums/server/http/UsbFileProvider;)V", "onRequest", "", "request", "Lcom/koushikdutta/async/http/server/AsyncHttpServerRequest;", "response", "Lcom/koushikdutta/async/http/server/AsyncHttpServerResponse;", "start", "stop", "Companion", "libaums-httpserver_release"})
public final class AsyncHttpServer
implements HttpServer,
HttpServerRequestCallback {
    @NotNull
    public UsbFileProvider usbFileProvider;
    private final com.koushikdutta.async.http.server.AsyncHttpServer server;
    private boolean isAlive;
    private final int port;
    private static final String TAG;
    public static final Companion Companion;

    @Override
    @NotNull
    public UsbFileProvider getUsbFileProvider() {
        UsbFileProvider usbFileProvider = this.usbFileProvider;
        if (usbFileProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbFileProvider");
        }
        return usbFileProvider;
    }

    @Override
    public void setUsbFileProvider(@NotNull UsbFileProvider usbFileProvider) {
        Intrinsics.checkParameterIsNotNull((Object)usbFileProvider, (String)"<set-?>");
        this.usbFileProvider = usbFileProvider;
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    public void setAlive(boolean bl) {
        this.isAlive = bl;
    }

    @Override
    @NotNull
    public String getHostname() {
        return "";
    }

    @Override
    public int getListeningPort() {
        return this.port;
    }

    @Override
    public void start() throws IOException {
        this.server.listen(this.port);
        this.setAlive(true);
    }

    @Override
    public void stop() throws IOException {
        this.server.stop();
        AsyncServer.getDefault().stop();
        this.setAlive(false);
    }

    public void onRequest(@NotNull AsyncHttpServerRequest request, @NotNull AsyncHttpServerResponse response) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        String uri = null;
        try {
            String string = URLDecoder.decode(request.getPath(), "utf-8");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLDecoder.decode(request.path, \"utf-8\")");
            uri = string;
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"could not decode URL", (Throwable)e);
            response.code(404);
            response.send(e.getMessage());
            return;
        }
        Log.d((String)TAG, (String)("Uri: " + uri));
        try {
            UsbFile fileToServe = this.getUsbFileProvider().determineFileToServe(uri);
            response.sendStream((InputStream)new UsbFileInputStream(fileToServe), fileToServe.getLength());
        }
        catch (FileNotFoundException e) {
            response.code(404);
            response.send(e.getMessage());
        }
        catch (NotAFileException e) {
            response.code(400);
            response.send(e.getMessage());
        }
        catch (IOException e) {
            response.code(500);
            response.send(e.getMessage());
        }
    }

    public AsyncHttpServer(int port) {
        this.port = port;
        this.server = new com.koushikdutta.async.http.server.AsyncHttpServer();
        this.server.get("/.*", (HttpServerRequestCallback)this);
    }

    static {
        Companion = new Companion(null);
        String string = AsyncHttpServer.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"AsyncHttpServer::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/mjdev/libaums/server/http/server/AsyncHttpServer$Companion;", "", "()V", "TAG", "", "libaums-httpserver_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

