/*
 * Decompiled with CFR 0.152.
 */
package me.himanshusoni.quantityview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import me.himanshusoni.quantityview.R;

public class QuantityView
extends LinearLayout
implements View.OnClickListener {
    private Drawable quantityBackground;
    private Drawable addButtonBackground;
    private Drawable removeButtonBackground;
    private String addButtonText;
    private String removeButtonText;
    private int quantity;
    private int maxQuantity;
    private int minQuantity;
    private int quantityPadding;
    private int quantityTextColor;
    private int addButtonTextColor;
    private int removeButtonTextColor;
    private Button mButtonAdd;
    private Button mButtonRemove;
    private TextView mTextViewQuantity;
    private OnQuantityChangeListener onQuantityChangeListener;

    public QuantityView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public QuantityView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public QuantityView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    @TargetApi(value=16)
    private void init(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.QuantityView, defStyle, 0);
        this.addButtonText = this.getResources().getString(R.string.qv_add);
        if (a.hasValue(R.styleable.QuantityView_qv_addButtonText)) {
            this.addButtonText = a.getString(R.styleable.QuantityView_qv_addButtonText);
        }
        this.addButtonBackground = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.qv_btn_selector);
        if (a.hasValue(R.styleable.QuantityView_qv_addButtonBackground)) {
            this.addButtonBackground = a.getDrawable(R.styleable.QuantityView_qv_addButtonBackground);
        }
        this.addButtonTextColor = a.getColor(R.styleable.QuantityView_qv_addButtonTextColor, -16777216);
        this.removeButtonText = this.getResources().getString(R.string.qv_remove);
        if (a.hasValue(R.styleable.QuantityView_qv_removeButtonText)) {
            this.removeButtonText = a.getString(R.styleable.QuantityView_qv_removeButtonText);
        }
        this.removeButtonBackground = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.qv_btn_selector);
        if (a.hasValue(R.styleable.QuantityView_qv_removeButtonBackground)) {
            this.removeButtonBackground = a.getDrawable(R.styleable.QuantityView_qv_removeButtonBackground);
        }
        this.removeButtonTextColor = a.getColor(R.styleable.QuantityView_qv_removeButtonTextColor, -16777216);
        this.quantity = a.getInt(R.styleable.QuantityView_qv_quantity, 0);
        this.maxQuantity = a.getInt(R.styleable.QuantityView_qv_maxQuantity, Integer.MAX_VALUE);
        this.minQuantity = a.getInt(R.styleable.QuantityView_qv_minQuantity, 0);
        this.quantityPadding = (int)a.getDimension(R.styleable.QuantityView_qv_quantityPadding, (float)this.pxFromDp(24.0f));
        this.quantityTextColor = a.getColor(R.styleable.QuantityView_qv_quantityTextColor, -16777216);
        this.quantityBackground = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.qv_bg_selector);
        if (a.hasValue(R.styleable.QuantityView_qv_quantityBackground)) {
            this.quantityBackground = a.getDrawable(R.styleable.QuantityView_qv_quantityBackground);
        }
        a.recycle();
        int dp10 = this.pxFromDp(10.0f);
        this.mButtonAdd = new Button(this.getContext());
        this.mButtonAdd.setGravity(17);
        this.mButtonAdd.setPadding(dp10, dp10, dp10, dp10);
        this.mButtonAdd.setMinimumHeight(0);
        this.mButtonAdd.setMinimumWidth(0);
        this.mButtonAdd.setMinHeight(0);
        this.mButtonAdd.setMinWidth(0);
        this.setAddButtonBackground(this.addButtonBackground);
        this.setAddButtonText(this.addButtonText);
        this.setAddButtonTextColor(this.addButtonTextColor);
        this.mButtonRemove = new Button(this.getContext());
        this.mButtonRemove.setGravity(17);
        this.mButtonRemove.setPadding(dp10, dp10, dp10, dp10);
        this.mButtonRemove.setMinimumHeight(0);
        this.mButtonRemove.setMinimumWidth(0);
        this.mButtonRemove.setMinHeight(0);
        this.mButtonRemove.setMinWidth(0);
        this.setRemoveButtonBackground(this.removeButtonBackground);
        this.setRemoveButtonText(this.removeButtonText);
        this.setRemoveButtonTextColor(this.removeButtonTextColor);
        this.mTextViewQuantity = new TextView(this.getContext());
        this.mTextViewQuantity.setGravity(17);
        this.setQuantityTextColor(this.quantityTextColor);
        this.setQuantity(this.quantity);
        this.setQuantityBackground(this.quantityBackground);
        this.setQuantityPadding(this.quantityPadding);
        this.setOrientation(0);
        this.addView((View)this.mButtonRemove, -2, -2);
        this.addView((View)this.mTextViewQuantity, -2, -1);
        this.addView((View)this.mButtonAdd, -2, -2);
        this.mButtonAdd.setOnClickListener((View.OnClickListener)this);
        this.mButtonRemove.setOnClickListener((View.OnClickListener)this);
        this.mTextViewQuantity.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (v == this.mButtonAdd) {
            if (this.quantity + 1 > this.maxQuantity) {
                if (this.onQuantityChangeListener != null) {
                    this.onQuantityChangeListener.onLimitReached();
                }
            } else {
                ++this.quantity;
                this.mTextViewQuantity.setText((CharSequence)String.valueOf(this.quantity));
                if (this.onQuantityChangeListener != null) {
                    this.onQuantityChangeListener.onQuantityChanged(this.quantity, false);
                }
            }
        } else if (v == this.mButtonRemove) {
            if (this.quantity - 1 < this.minQuantity) {
                if (this.onQuantityChangeListener != null) {
                    this.onQuantityChangeListener.onLimitReached();
                }
            } else {
                --this.quantity;
                this.mTextViewQuantity.setText((CharSequence)String.valueOf(this.quantity));
                if (this.onQuantityChangeListener != null) {
                    this.onQuantityChangeListener.onQuantityChanged(this.quantity, false);
                }
            }
        } else if (v == this.mTextViewQuantity) {
            AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
            builder.setTitle((CharSequence)"Change Quantity");
            View inflate = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.qv_dialog_changequantity, null, false);
            final EditText et = (EditText)inflate.findViewById(R.id.qv_et_change_qty);
            et.setText((CharSequence)String.valueOf(this.quantity));
            builder.setView(inflate);
            builder.setPositiveButton((CharSequence)"Change", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    String newQuantity = et.getText().toString();
                    if (QuantityView.this.isNumber(newQuantity)) {
                        int intNewQuantity = Integer.parseInt(newQuantity);
                        QuantityView.this.setQuantity(intNewQuantity);
                    }
                }
            }).setNegativeButton((CharSequence)"Cancel", null);
            builder.show();
        }
    }

    public OnQuantityChangeListener getOnQuantityChangeListener() {
        return this.onQuantityChangeListener;
    }

    public void setOnQuantityChangeListener(OnQuantityChangeListener onQuantityChangeListener) {
        this.onQuantityChangeListener = onQuantityChangeListener;
    }

    public Drawable getQuantityBackground() {
        return this.quantityBackground;
    }

    public void setQuantityBackground(Drawable quantityBackground) {
        this.quantityBackground = quantityBackground;
        if (Build.VERSION.SDK_INT >= 16) {
            this.mTextViewQuantity.setBackground(quantityBackground);
        } else {
            this.mTextViewQuantity.setBackgroundDrawable(quantityBackground);
        }
    }

    public Drawable getAddButtonBackground() {
        return this.addButtonBackground;
    }

    public void setAddButtonBackground(Drawable addButtonBackground) {
        this.addButtonBackground = addButtonBackground;
        if (Build.VERSION.SDK_INT >= 16) {
            this.mButtonAdd.setBackground(addButtonBackground);
        } else {
            this.mButtonAdd.setBackgroundDrawable(addButtonBackground);
        }
    }

    public Drawable getRemoveButtonBackground() {
        return this.removeButtonBackground;
    }

    public void setRemoveButtonBackground(Drawable removeButtonBackground) {
        this.removeButtonBackground = removeButtonBackground;
        if (Build.VERSION.SDK_INT >= 16) {
            this.mButtonRemove.setBackground(removeButtonBackground);
        } else {
            this.mButtonRemove.setBackgroundDrawable(removeButtonBackground);
        }
    }

    public String getAddButtonText() {
        return this.addButtonText;
    }

    public void setAddButtonText(String addButtonText) {
        this.addButtonText = addButtonText;
        this.mButtonAdd.setText((CharSequence)addButtonText);
    }

    public String getRemoveButtonText() {
        return this.removeButtonText;
    }

    public void setRemoveButtonText(String removeButtonText) {
        this.removeButtonText = removeButtonText;
        this.mButtonRemove.setText((CharSequence)removeButtonText);
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        boolean limitReached = false;
        if (quantity > this.maxQuantity) {
            quantity = this.maxQuantity;
            limitReached = true;
            if (this.onQuantityChangeListener != null) {
                this.onQuantityChangeListener.onLimitReached();
            }
        }
        if (quantity < this.minQuantity) {
            quantity = this.minQuantity;
            limitReached = true;
            if (this.onQuantityChangeListener != null) {
                this.onQuantityChangeListener.onLimitReached();
            }
        }
        if (!limitReached && this.onQuantityChangeListener != null) {
            this.onQuantityChangeListener.onQuantityChanged(quantity, true);
        }
        this.quantity = quantity;
        this.mTextViewQuantity.setText((CharSequence)String.valueOf(this.quantity));
    }

    public int getMaxQuantity() {
        return this.maxQuantity;
    }

    public void setMaxQuantity(int maxQuantity) {
        this.maxQuantity = maxQuantity;
    }

    public int getMinQuantity() {
        return this.minQuantity;
    }

    public void setMinQuantity(int minQuantity) {
        this.minQuantity = minQuantity;
    }

    public int getQuantityPadding() {
        return this.quantityPadding;
    }

    public void setQuantityPadding(int quantityPadding) {
        this.quantityPadding = quantityPadding;
        this.mTextViewQuantity.setPadding(quantityPadding, 0, quantityPadding, 0);
    }

    public int getQuantityTextColor() {
        return this.quantityTextColor;
    }

    public void setQuantityTextColor(int quantityTextColor) {
        this.quantityTextColor = quantityTextColor;
        this.mTextViewQuantity.setTextColor(quantityTextColor);
    }

    public void setQuantityTextColorRes(int quantityTextColorRes) {
        this.quantityTextColor = ContextCompat.getColor((Context)this.getContext(), (int)quantityTextColorRes);
        this.mTextViewQuantity.setTextColor(this.quantityTextColor);
    }

    public int getAddButtonTextColor() {
        return this.addButtonTextColor;
    }

    public void setAddButtonTextColor(int addButtonTextColor) {
        this.addButtonTextColor = addButtonTextColor;
        this.mButtonAdd.setTextColor(addButtonTextColor);
    }

    public void setAddButtonTextColorRes(int addButtonTextColorRes) {
        this.addButtonTextColor = ContextCompat.getColor((Context)this.getContext(), (int)addButtonTextColorRes);
        this.mButtonAdd.setTextColor(this.addButtonTextColor);
    }

    public int getRemoveButtonTextColor() {
        return this.removeButtonTextColor;
    }

    public void setRemoveButtonTextColor(int removeButtonTextColor) {
        this.removeButtonTextColor = removeButtonTextColor;
        this.mButtonRemove.setTextColor(removeButtonTextColor);
    }

    public void setRemoveButtonTextColorRes(int removeButtonTextColorRes) {
        this.removeButtonTextColor = ContextCompat.getColor((Context)this.getContext(), (int)removeButtonTextColorRes);
        this.mButtonRemove.setTextColor(this.removeButtonTextColor);
    }

    private int dpFromPx(float px) {
        return (int)(px / this.getResources().getDisplayMetrics().density);
    }

    private int pxFromDp(float dp) {
        return (int)(dp * this.getResources().getDisplayMetrics().density);
    }

    private boolean isNumber(String string2) {
        try {
            Integer.parseInt(string2);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static interface OnQuantityChangeListener {
        public void onQuantityChanged(int var1, boolean var2);

        public void onLimitReached();
    }
}

