/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import me.henrytao.smoothappbarlayout.R;

public class SmoothCollapsingToolbarLayout
extends LinearLayout {
    public static boolean DEBUG = false;
    protected int mAvatarId;
    protected float mCollapsedAvatarSize;
    protected float mCollapsedOffsetX;
    protected float mCollapsedOffsetY;
    protected float mCollapsedSubTitleTextSize;
    protected float mCollapsedTitleTextSize;
    protected float mCurrentRatio;
    protected float mExpandedAvatarSize;
    protected float mExpandedOffsetX;
    protected float mExpandedOffsetY;
    protected float mExpandedSubtitleTextSize;
    protected float mExpandedTitleTextSize;
    protected AppBarLayout.OnOffsetChangedListener mOnAppBarLayoutOffsetChangedListener;
    protected OnOffsetChangedListener mOnOffsetChangedListener;
    protected int mSubtitleId;
    protected int mTitleId;
    protected AppBarLayout vAppBarLayout;
    protected View vAvatar;
    protected CollapsingToolbarLayout vCollapsingToolbarLayout;
    protected TextView vSubtitle;
    protected TextView vTitle;
    protected Toolbar vToolbar;

    private static void log(String s, Object ... args) {
        if (DEBUG) {
            Log.d((String)"debug", (String)String.format(s, args));
        }
    }

    public SmoothCollapsingToolbarLayout(Context context) {
        super(context);
        this.init(null);
    }

    public SmoothCollapsingToolbarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    @TargetApi(value=11)
    public SmoothCollapsingToolbarLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public SmoothCollapsingToolbarLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.initViews();
        if (!this.isInEditMode()) {
            this.mOnAppBarLayoutOffsetChangedListener = new AppBarLayout.OnOffsetChangedListener(){

                public void onOffsetChanged(AppBarLayout appBarLayout, int i) {
                    SmoothCollapsingToolbarLayout.this.onOffsetChanged(appBarLayout, i);
                }
            };
            this.getAppBarLayout().addOnOffsetChangedListener(this.mOnAppBarLayoutOffsetChangedListener);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mOnAppBarLayoutOffsetChangedListener != null) {
            this.getAppBarLayout().removeOnOffsetChangedListener(this.mOnAppBarLayoutOffsetChangedListener);
        }
        super.onDetachedFromWindow();
    }

    public void setCollapsedAvatarSize(float collapsedAvatarSize) {
        this.mCollapsedAvatarSize = collapsedAvatarSize;
        this.updateViews();
    }

    public void setCollapsedOffsetX(float collapsedOffsetX) {
        this.mCollapsedOffsetX = collapsedOffsetX;
        this.updateViews();
    }

    public void setCollapsedOffsetY(float collapsedOffsetY) {
        this.mCollapsedOffsetY = collapsedOffsetY;
        this.updateViews();
    }

    public void setCollapsedSubTitleTextSize(float collapsedSubTitleTextSize) {
        this.mCollapsedSubTitleTextSize = collapsedSubTitleTextSize;
        this.updateViews();
    }

    public void setCollapsedTitleTextSize(float collapsedTitleTextSize) {
        this.mCollapsedTitleTextSize = collapsedTitleTextSize;
        this.updateViews();
    }

    public void setExpandedAvatarSize(float expandedAvatarSize) {
        this.mExpandedAvatarSize = expandedAvatarSize;
        this.updateViews();
    }

    public void setExpandedOffsetX(float expandedOffsetX) {
        this.mExpandedOffsetX = expandedOffsetX;
        this.updateViews();
    }

    public void setExpandedOffsetY(float expandedOffsetY) {
        this.mExpandedOffsetY = expandedOffsetY;
        this.updateViews();
    }

    public void setExpandedSubtitleTextSize(float expandedSubtitleTextSize) {
        this.mExpandedSubtitleTextSize = expandedSubtitleTextSize;
        this.updateViews();
    }

    public void setExpandedTitleTextSize(float expandedTitleTextSize) {
        this.mExpandedTitleTextSize = expandedTitleTextSize;
        this.updateViews();
    }

    public void setOnOffsetChangedListener(OnOffsetChangedListener onOffsetChangedListener) {
        this.mOnOffsetChangedListener = onOffsetChangedListener;
    }

    protected AppBarLayout getAppBarLayout() {
        if (this.vAppBarLayout == null) {
            if (this.getParent() instanceof CollapsingToolbarLayout && this.getParent().getParent() instanceof AppBarLayout) {
                this.vAppBarLayout = (AppBarLayout)this.getParent().getParent();
            } else {
                throw new IllegalStateException("Must be inside a CollapsingToolbarLayout and AppBarLayout");
            }
        }
        return this.vAppBarLayout;
    }

    protected CollapsingToolbarLayout getCollapsingToolbarLayout() {
        if (this.vCollapsingToolbarLayout == null) {
            if (this.getParent() instanceof CollapsingToolbarLayout) {
                this.vCollapsingToolbarLayout = (CollapsingToolbarLayout)this.getParent();
            } else {
                throw new IllegalStateException("Must be inside a CollapsingToolbarLayout");
            }
        }
        return this.vCollapsingToolbarLayout;
    }

    protected Toolbar getToolbar() {
        if (this.vToolbar == null) {
            ViewGroup parent = (ViewGroup)this.getParent();
            int z = parent.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = parent.getChildAt(i);
                if (!(child instanceof Toolbar)) continue;
                this.vToolbar = (Toolbar)child;
                break;
            }
            if (this.vToolbar == null) {
                throw new IllegalStateException("Must have Toolbar");
            }
        }
        return this.vToolbar;
    }

    protected float getTranslationOffset(float expandedOffset, float collapsedOffset, float ratio) {
        return expandedOffset + ratio * (collapsedOffset - expandedOffset);
    }

    protected void init(AttributeSet attrs) {
        this.setOrientation(0);
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SmoothCollapsingToolbarLayout, 0, 0);
        try {
            this.mCollapsedOffsetX = a.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_collapsed_offsetX, 0.0f);
            this.mCollapsedOffsetY = a.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_collapsed_offsetY, 0.0f);
            this.mCollapsedAvatarSize = a.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_collapsed_avatarSize, -1.0f);
            this.mCollapsedTitleTextSize = a.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_collapsed_titleTextSize, -1.0f);
            this.mCollapsedSubTitleTextSize = a.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_collapsed_subtitleTextSize, -1.0f);
            this.mExpandedOffsetX = a.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_expanded_offsetX, 0.0f);
            this.mExpandedOffsetY = a.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_expanded_offsetY, 0.0f);
            this.mExpandedAvatarSize = a.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_expanded_avatarSize, -1.0f);
            this.mExpandedTitleTextSize = a.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_expanded_titleTextSize, -1.0f);
            this.mExpandedSubtitleTextSize = a.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_expanded_subtitleTextSize, -1.0f);
            this.mAvatarId = a.getResourceId(R.styleable.SmoothCollapsingToolbarLayout_sctl_avatar_id, 0);
            this.mTitleId = a.getResourceId(R.styleable.SmoothCollapsingToolbarLayout_sctl_title_id, 0);
            this.mSubtitleId = a.getResourceId(R.styleable.SmoothCollapsingToolbarLayout_sctl_subtitle_id, 0);
        }
        finally {
            a.recycle();
        }
    }

    protected void initViews() {
        this.updateViews();
        if (this.mAvatarId > 0) {
            this.vAvatar = this.findViewById(this.mAvatarId);
        }
        if (this.mTitleId > 0) {
            this.vTitle = (TextView)this.findViewById(this.mTitleId);
        }
        if (this.mSubtitleId > 0) {
            this.vSubtitle = (TextView)this.findViewById(this.mSubtitleId);
        }
    }

    protected boolean isAvatarSizeEnabled() {
        return this.vAvatar != null && this.mCollapsedAvatarSize > 0.0f && this.mExpandedAvatarSize > 0.0f;
    }

    protected boolean isSubtitleTextSizeEnabled() {
        return this.vSubtitle != null && this.mCollapsedSubTitleTextSize > 0.0f && this.mExpandedSubtitleTextSize > 0.0f;
    }

    protected boolean isTitleTextSizeEnabled() {
        return this.vTitle != null && this.mCollapsedTitleTextSize > 0.0f && this.mExpandedTitleTextSize > 0.0f;
    }

    protected void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
        int maxOffset = this.getAppBarLayout().getMeasuredHeight() - this.getToolbar().getMeasuredHeight();
        float ratio = Math.min((float)Math.abs(verticalOffset) * 1.0f / (float)maxOffset, 1.0f);
        this.updateViews(ratio);
        SmoothCollapsingToolbarLayout.log("test onOffsetChanged collapsing | %d | %f", verticalOffset, Float.valueOf(ratio));
    }

    protected void updateViews() {
        this.updateViews(this.mCurrentRatio);
    }

    protected void updateViews(float ratio) {
        this.mCurrentRatio = ratio;
        boolean startOffsetX = false;
        int startOffsetY = this.getAppBarLayout().getMeasuredHeight() - this.getMeasuredHeight();
        ViewCompat.setTranslationX((View)this, (float)((float)startOffsetX + this.getTranslationOffset(this.mExpandedOffsetX, this.mCollapsedOffsetX, ratio)));
        ViewCompat.setTranslationY((View)this, (float)((float)startOffsetY - this.getTranslationOffset(this.mExpandedOffsetY, this.mCollapsedOffsetY, ratio)));
        if (this.isAvatarSizeEnabled()) {
            ViewGroup.LayoutParams params = this.vAvatar.getLayoutParams();
            params.height = params.width = (int)this.getTranslationOffset(this.mExpandedAvatarSize, this.mCollapsedAvatarSize, ratio);
        }
        if (this.isTitleTextSizeEnabled()) {
            this.vTitle.setTextSize(0, this.getTranslationOffset(this.mExpandedTitleTextSize, this.mCollapsedTitleTextSize, ratio));
        }
        if (this.isSubtitleTextSizeEnabled()) {
            this.vSubtitle.setTextSize(0, this.getTranslationOffset(this.mExpandedSubtitleTextSize, this.mCollapsedSubTitleTextSize, ratio));
        }
        if (this.mOnOffsetChangedListener != null) {
            this.mOnOffsetChangedListener.onOffsetChanged(ratio);
        }
        SmoothCollapsingToolbarLayout.log("test updateViews | %d | %f", (int)(this.mExpandedAvatarSize + ratio * (this.mCollapsedAvatarSize - this.mExpandedAvatarSize)), Float.valueOf(ratio));
    }

    public static interface OnOffsetChangedListener {
        public void onOffsetChanged(float var1);
    }
}

