/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import me.henrytao.smoothappbarlayout.BaseBehavior;
import me.henrytao.smoothappbarlayout.R;
import me.henrytao.smoothappbarlayout.base.ObservableFragment;
import me.henrytao.smoothappbarlayout.base.ObservablePagerAdapter;
import me.henrytao.smoothappbarlayout.base.OnOffsetChangedListener;
import me.henrytao.smoothappbarlayout.base.ScrollFlag;
import me.henrytao.smoothappbarlayout.base.ScrollTargetCallback;
import me.henrytao.smoothappbarlayout.base.Utils;

@CoordinatorLayout.DefaultBehavior(value=Behavior.class)
public class SmoothAppBarLayout
extends AppBarLayout {
    private static final String ARG_CURRENT_OFFSET = "ARG_CURRENT_OFFSET";
    private static final String ARG_SUPER = "ARG_SUPER";
    public static boolean DEBUG = false;
    protected final List<WeakReference<AppBarLayout.OnOffsetChangedListener>> mOffsetChangedListeners = new ArrayList<WeakReference<AppBarLayout.OnOffsetChangedListener>>();
    protected boolean mHaveChildWithInterpolator;
    private int mRestoreCurrentOffset;
    private ScrollTargetCallback mScrollTargetCallback;
    private OnOffsetChangedListener mSyncOffsetListener;
    private int mTargetId;
    private int mViewPagerId;
    private ViewPager vViewPager;

    public SmoothAppBarLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public SmoothAppBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public void addOnOffsetChangedListener(AppBarLayout.OnOffsetChangedListener listener) {
        super.addOnOffsetChangedListener(listener);
        int z = this.mOffsetChangedListeners.size();
        for (int i = 0; i < z; ++i) {
            WeakReference<AppBarLayout.OnOffsetChangedListener> ref = this.mOffsetChangedListeners.get(i);
            if (ref == null || ref.get() != listener) continue;
            return;
        }
        this.mOffsetChangedListeners.add(new WeakReference<AppBarLayout.OnOffsetChangedListener>(listener));
    }

    public void removeOnOffsetChangedListener(AppBarLayout.OnOffsetChangedListener listener) {
        super.removeOnOffsetChangedListener(listener);
        Iterator<WeakReference<AppBarLayout.OnOffsetChangedListener>> i = this.mOffsetChangedListeners.iterator();
        while (i.hasNext()) {
            WeakReference<AppBarLayout.OnOffsetChangedListener> ref = i.next();
            AppBarLayout.OnOffsetChangedListener item = (AppBarLayout.OnOffsetChangedListener)ref.get();
            if (item != listener && item != null) continue;
            i.remove();
        }
        return;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.initViews();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            AppBarLayout.LayoutParams childLp = (AppBarLayout.LayoutParams)child.getLayoutParams();
            Interpolator interpolator = childLp.getScrollInterpolator();
            if (interpolator == null) continue;
            this.mHaveChildWithInterpolator = true;
            break;
        }
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle bundle = (Bundle)state;
        this.mRestoreCurrentOffset = bundle.getInt(ARG_CURRENT_OFFSET);
        Parcelable superState = bundle.getParcelable(ARG_SUPER);
        super.onRestoreInstanceState(superState);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putInt(ARG_CURRENT_OFFSET, this.getCurrentOffset());
        bundle.putParcelable(ARG_SUPER, super.onSaveInstanceState());
        return bundle;
    }

    public int getCurrentOffset() {
        return -Utils.parseInt(this.getTag(R.id.tag_current_offset));
    }

    public void setScrollTargetCallback(ScrollTargetCallback scrollTargetCallback) {
        this.mScrollTargetCallback = scrollTargetCallback;
    }

    public void syncOffset(int newOffset) {
        this.syncOffset(newOffset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SmoothAppBarLayout, 0, 0);
        try {
            this.mViewPagerId = a.getResourceId(R.styleable.SmoothAppBarLayout_sabl_view_pager_id, 0);
            this.mTargetId = a.getResourceId(R.styleable.SmoothAppBarLayout_sabl_target_id, 0);
        }
        finally {
            a.recycle();
        }
    }

    private void initViews() {
        if (this.mViewPagerId > 0) {
            this.vViewPager = (ViewPager)this.getRootView().findViewById(this.mViewPagerId);
        } else {
            ViewGroup parent = (ViewGroup)this.getParent();
            int z = parent.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = parent.getChildAt(i);
                if (!(child instanceof ViewPager)) continue;
                this.vViewPager = (ViewPager)child;
                break;
            }
        }
    }

    private void setSyncOffsetListener(OnOffsetChangedListener syncOffsetListener) {
        this.mSyncOffsetListener = syncOffsetListener;
        this.syncOffset(this.mRestoreCurrentOffset, true);
    }

    private void syncOffset(int newOffset, boolean force) {
        this.mRestoreCurrentOffset = newOffset;
        if (this.mSyncOffsetListener != null) {
            this.mSyncOffsetListener.onOffsetChanged(this, newOffset, force);
        }
    }

    public static class Behavior
    extends BaseBehavior {
        protected ScrollFlag mScrollFlag;
        private int mLastY;
        private int mStatusBarSize;
        private ViewPager vViewPager;

        @Override
        protected void onInit(CoordinatorLayout coordinatorLayout, AppBarLayout child) {
            Utils.log("widget | onInit", new Object[0]);
            if (this.mScrollFlag == null) {
                this.mScrollFlag = new ScrollFlag(child);
            }
            if (child instanceof SmoothAppBarLayout) {
                final SmoothAppBarLayout layout = (SmoothAppBarLayout)child;
                this.setScrollTargetCallback(layout.mScrollTargetCallback);
                this.vViewPager = layout.vViewPager;
                if (this.vViewPager != null) {
                    this.vViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                        public void onPageScrollStateChanged(int state) {
                        }

                        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                        }

                        public void onPageSelected(int position) {
                            Behavior.this.propagateViewPagerOffset(layout, true);
                        }
                    });
                }
                layout.setSyncOffsetListener(new OnOffsetChangedListener(){

                    @Override
                    public void onOffsetChanged(SmoothAppBarLayout smoothAppBarLayout, int verticalOffset, boolean isOrientationChanged) {
                        Behavior.this.syncOffset(smoothAppBarLayout, -verticalOffset);
                        if (!isOrientationChanged) {
                            Behavior.this.propagateViewPagerOffset(smoothAppBarLayout, false);
                        }
                    }
                });
                this.temporaryInit(coordinatorLayout, child);
            }
        }

        @Override
        protected void onScrollChanged(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int y, int dy, boolean accuracy) {
            ObservablePagerAdapter pagerAdapter;
            if (!this.mScrollFlag.isFlagScrollEnabled() || !(child instanceof SmoothAppBarLayout)) {
                return;
            }
            int targetId = ((SmoothAppBarLayout)child).mTargetId;
            if (targetId > 0 && targetId != target.getId()) {
                return;
            }
            if (this.vViewPager != null && this.vViewPager.getAdapter() instanceof ObservablePagerAdapter && (pagerAdapter = (ObservablePagerAdapter)this.vViewPager.getAdapter()).getObservableFragment(this.vViewPager.getCurrentItem()).getScrollTarget() != target) {
                return;
            }
            if (y == this.mLastY) {
                return;
            }
            this.mLastY = y;
            int oDy = dy;
            int minOffset = this.getMinOffset(child);
            int maxOffset = this.getMaxOffset(child);
            int translationOffset = accuracy ? Math.min(Math.max(minOffset, -y), maxOffset) : minOffset;
            int n = dy = dy != 0 ? dy : y + this.getCurrentOffset();
            if (this.mScrollFlag.isQuickReturnEnabled()) {
                translationOffset = this.getCurrentOffset() - dy;
                translationOffset = Math.min(Math.max(minOffset, translationOffset), maxOffset);
                int breakPoint = minOffset + this.getMinHeight(child, true);
                if (!(dy > 0 || accuracy && y <= Math.abs(breakPoint))) {
                    translationOffset = Math.min(translationOffset, breakPoint);
                }
                translationOffset = !accuracy && oDy == 0 && this.getCurrentOffset() == minOffset ? minOffset : translationOffset;
            } else if (this.mScrollFlag.isFlagEnterAlwaysEnabled()) {
                translationOffset = this.getCurrentOffset() - dy;
                translationOffset = Math.min(Math.max(minOffset, translationOffset), maxOffset);
            } else if (this.mScrollFlag.isFlagEnterAlwaysCollapsedEnabled() || this.mScrollFlag.isFlagExitUntilCollapsedEnabled()) {
                // empty if block
            }
            Utils.log("widget | onScrollChanged | %d | %d | %d | %d | %d | %b | %d", minOffset, maxOffset, this.getCurrentOffset(), y, dy, accuracy, translationOffset);
            this.syncOffset(child, translationOffset);
            this.propagateViewPagerOffset((SmoothAppBarLayout)child, false);
        }

        protected int getMaxOffset(AppBarLayout layout) {
            return 0;
        }

        protected int getMinOffset(AppBarLayout layout) {
            int minOffset = layout.getMeasuredHeight();
            if (this.mScrollFlag != null && this.mScrollFlag.isFlagScrollEnabled()) {
                minOffset = layout.getMeasuredHeight() - this.getMinHeight(layout, false);
            }
            if (ViewCompat.getFitsSystemWindows((View)layout)) {
                if (this.mStatusBarSize == 0) {
                    this.mStatusBarSize = Utils.getStatusBarSize(layout.getContext());
                }
                minOffset -= this.mStatusBarSize;
            }
            return -Math.max(minOffset, 0);
        }

        private int getMinHeight(AppBarLayout layout, boolean forceQuickReturn) {
            int minHeight = ViewCompat.getMinimumHeight((View)layout);
            if (this.mScrollFlag.isFlagExitUntilCollapsedEnabled() || minHeight > 0 && !this.mScrollFlag.isQuickReturnEnabled() || forceQuickReturn) {
                return minHeight > 0 ? minHeight : ViewCompat.getMinimumHeight((View)this.mScrollFlag.getView());
            }
            return 0;
        }

        private boolean propagateViewPagerOffset(SmoothAppBarLayout smoothAppBarLayout, int position) {
            if (this.vViewPager != null && this.vViewPager.getAdapter() instanceof ObservablePagerAdapter) {
                int n = this.vViewPager.getAdapter().getCount();
                if (position >= 0 && position < n) {
                    int currentItem = this.vViewPager.getCurrentItem();
                    int currentOffset = Math.max(0, -this.getCurrentOffset());
                    Utils.log("widget | propagateViewPagerOffset | %d | %d | %d", currentItem, position, currentOffset);
                    try {
                        ObservablePagerAdapter pagerAdapter = (ObservablePagerAdapter)this.vViewPager.getAdapter();
                        ObservableFragment fragment = pagerAdapter.getObservableFragment(position);
                        View target = pagerAdapter.getObservableFragment(currentItem).getScrollTarget();
                        return fragment.onOffsetChanged(smoothAppBarLayout, target, currentOffset);
                    }
                    catch (Exception ex) {
                        Log.e((String)"SmoothAppBarLayout", (String)String.format(Locale.US, "ViewPager at position %d and %d need to implement %s", currentItem, position, ObservableFragment.class.getName()));
                    }
                }
            }
            return true;
        }

        private void propagateViewPagerOffset(SmoothAppBarLayout smoothAppBarLayout, boolean isOnPageSelected) {
            if (this.vViewPager != null) {
                Utils.log("widget | propagateViewPagerOffset | isPageSelected | %b", isOnPageSelected);
                int currentItem = this.vViewPager.getCurrentItem();
                boolean shouldPropagate = true;
                if (isOnPageSelected) {
                    shouldPropagate = this.propagateViewPagerOffset(smoothAppBarLayout, currentItem);
                }
                if (shouldPropagate) {
                    int n = this.vViewPager.getAdapter().getCount();
                    for (int i = 0; i < n; ++i) {
                        if (i == currentItem) continue;
                        this.propagateViewPagerOffset(smoothAppBarLayout, i);
                    }
                }
            }
        }
    }
}

