/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout;

import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.widget.NestedScrollView;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import me.henrytao.smoothappbarlayout.R;
import me.henrytao.smoothappbarlayout.SmoothAppBarLayout;
import me.henrytao.smoothappbarlayout.base.ObservableNestedScrollView;
import me.henrytao.smoothappbarlayout.base.ObservableRecyclerView;
import me.henrytao.smoothappbarlayout.base.OnScrollListener;
import me.henrytao.smoothappbarlayout.base.ScrollTargetCallback;
import me.henrytao.smoothappbarlayout.base.Utils;

public abstract class BaseBehavior
extends AppBarLayout.Behavior {
    private CoordinatorLayout mCoordinatorLayout;
    private int mCurrentOffset;
    private AppBarLayout.Behavior.DragCallback mDragCallbackListener;
    private boolean mIsOnInit = false;
    private boolean mIsPullDownFromTop;
    private boolean mOverrideOnScrollListener;
    private ScrollTargetCallback mScrollTargetCallback;
    private List<Long> mScrollTargets = new ArrayList<Long>();
    private View vScrollTarget;

    protected abstract void onInit(CoordinatorLayout var1, AppBarLayout var2);

    protected abstract void onScrollChanged(CoordinatorLayout var1, AppBarLayout var2, View var3, int var4, int var5, boolean var6);

    public BaseBehavior() {
    }

    public BaseBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean onMeasureChild(CoordinatorLayout coordinatorLayout, AppBarLayout child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        if (!this.mIsOnInit && coordinatorLayout != null && child != null) {
            this.mIsOnInit = true;
            this.init(coordinatorLayout, child);
        }
        return super.onMeasureChild(coordinatorLayout, child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    public boolean onNestedFling(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, float velocityX, float velocityY, boolean consumed) {
        Utils.log("onNestedFling | %f | %f | %b", Float.valueOf(velocityX), Float.valueOf(velocityY), consumed);
        return true;
    }

    public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, float velocityX, float velocityY) {
        Utils.log("onNestedPreFling | %f | %f", Float.valueOf(velocityX), Float.valueOf(velocityY));
        return false;
    }

    public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dx, int dy, int[] consumed) {
        Utils.log("onNestedPreScroll | %d | %d", dx, dy);
        this.vScrollTarget = this.getScrollTarget(target);
        this.initScrollTarget(coordinatorLayout, child);
        if (dy < 0 && this.mIsPullDownFromTop) {
            this.onScrollChanged(coordinatorLayout, child, this.vScrollTarget, 0, dy, true);
        }
    }

    public void onNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        Utils.log("onNestedScroll | %d | %d | %d | %d", dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
        this.mIsPullDownFromTop = dyUnconsumed < 0;
    }

    public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, AppBarLayout child, View directTargetChild, View target, int nestedScrollAxes) {
        Utils.log("onNestedScrollAccepted | %d", nestedScrollAxes);
        this.onNestedPreScroll(coordinatorLayout, child, target, 0, 0, null);
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View directTargetChild, View target, int nestedScrollAxes) {
        Utils.log("onStartNestedScroll | %d", nestedScrollAxes);
        return true;
    }

    public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target) {
        Utils.log("onStopNestedScroll", new Object[0]);
    }

    public void setDragCallback(AppBarLayout.Behavior.DragCallback callback) {
        super.setDragCallback(callback);
        this.mDragCallbackListener = callback;
    }

    public int getCurrentOffset() {
        return this.mCurrentOffset;
    }

    public void setOverrideOnScrollListener(boolean overrideOnScrollListener) {
        this.mOverrideOnScrollListener = overrideOnScrollListener;
    }

    public void setScrollTargetCallback(ScrollTargetCallback scrollTargetCallback) {
        this.mScrollTargetCallback = scrollTargetCallback;
    }

    protected void dispatchOffsetUpdates(AppBarLayout layout, int translationOffset) {
        if (layout instanceof SmoothAppBarLayout) {
            List<WeakReference<AppBarLayout.OnOffsetChangedListener>> listeners = ((SmoothAppBarLayout)layout).mOffsetChangedListeners;
            int z = listeners.size();
            for (int i = 0; i < z; ++i) {
                AppBarLayout.OnOffsetChangedListener listener;
                WeakReference<AppBarLayout.OnOffsetChangedListener> ref = listeners.get(i);
                AppBarLayout.OnOffsetChangedListener onOffsetChangedListener = listener = ref != null ? (AppBarLayout.OnOffsetChangedListener)ref.get() : null;
                if (listener == null) continue;
                listener.onOffsetChanged(layout, translationOffset);
            }
        }
    }

    protected long getViewTag(View target, boolean createIfNotExist) {
        if (target == null) {
            return 0L;
        }
        Object tag = target.getTag(R.id.tag_view_target);
        if (tag == null) {
            if (!createIfNotExist) {
                return 0L;
            }
            tag = System.currentTimeMillis();
            target.setTag(R.id.tag_view_target, tag);
        }
        return (Long)tag;
    }

    protected void syncOffset(AppBarLayout child, int newOffset) {
        Utils.log("syncOffset | %d", newOffset);
        this.setTopAndBottomOffset(newOffset);
        if (child instanceof SmoothAppBarLayout && ((SmoothAppBarLayout)child).mHaveChildWithInterpolator && this.mCoordinatorLayout != null) {
            this.mCoordinatorLayout.dispatchDependentViewsChanged((View)child);
        }
        this.dispatchOffsetUpdates(child, newOffset);
        this.mCurrentOffset = newOffset;
        child.setTag(R.id.tag_current_offset, (Object)this.mCurrentOffset);
    }

    void temporaryInit(CoordinatorLayout coordinatorLayout, AppBarLayout child) {
        this.vScrollTarget = this.getScrollTarget((View)coordinatorLayout);
        this.initScrollTarget(coordinatorLayout, child);
    }

    private View getScrollTarget(View target) {
        return this.mScrollTargetCallback != null ? this.mScrollTargetCallback.callback(target) : this.getSupportedScrollTarget(target);
    }

    private View getSupportedScrollTarget(View target) {
        if (target instanceof SwipeRefreshLayout && ((SwipeRefreshLayout)target).getChildCount() > 0) {
            SwipeRefreshLayout parent = (SwipeRefreshLayout)target;
            int n = parent.getChildCount();
            for (int i = 0; i < n; ++i) {
                View child = parent.getChildAt(i);
                if (!(child instanceof NestedScrollView) && !(child instanceof RecyclerView)) continue;
                return child;
            }
            return ((SwipeRefreshLayout)target).getChildAt(0);
        }
        if (target instanceof CoordinatorLayout) {
            Stack<View> stack = new Stack<View>();
            stack.add(target);
            while (stack.size() > 0) {
                View view = (View)stack.pop();
                if (view instanceof NestedScrollView || view instanceof RecyclerView) {
                    return view;
                }
                if (!(view instanceof ViewGroup)) continue;
                int n = ((ViewGroup)view).getChildCount();
                for (int i = 0; i < n; ++i) {
                    stack.add(((ViewGroup)view).getChildAt(i));
                }
            }
        }
        return target;
    }

    private void init(CoordinatorLayout coordinatorLayout, AppBarLayout child) {
        if (this.mDragCallbackListener == null) {
            this.mDragCallbackListener = new AppBarLayout.Behavior.DragCallback(){

                public boolean canDrag(AppBarLayout appBarLayout) {
                    return false;
                }
            };
            this.setDragCallback(this.mDragCallbackListener);
        }
        Utils.log("onInit", new Object[0]);
        this.mCoordinatorLayout = coordinatorLayout;
        this.onInit(coordinatorLayout, child);
    }

    private void initScrollTarget(final CoordinatorLayout coordinatorLayout, final AppBarLayout child) {
        long tag;
        Utils.log("initScrollTarget | %b", this.vScrollTarget != null);
        if (this.vScrollTarget != null && !this.mScrollTargets.contains(tag = this.getViewTag(this.vScrollTarget, true))) {
            this.mScrollTargets.add(tag);
            OnScrollListener listener = new OnScrollListener(){

                @Override
                public void onScrollChanged(View view, int x, int y, int dx, int dy, boolean accuracy) {
                    if (view == BaseBehavior.this.vScrollTarget) {
                        BaseBehavior.this.onScrollChanged(coordinatorLayout, child, view, y, dy, accuracy);
                    }
                }
            };
            if (this.vScrollTarget instanceof NestedScrollView) {
                ObservableNestedScrollView.newInstance((NestedScrollView)this.vScrollTarget, this.mOverrideOnScrollListener, listener);
            } else if (this.vScrollTarget instanceof RecyclerView) {
                ObservableRecyclerView.newInstance((RecyclerView)this.vScrollTarget, listener);
            }
        }
    }
}

