/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout.base;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import me.henrytao.smoothappbarlayout.R;
import me.henrytao.smoothappbarlayout.base.Observer;
import me.henrytao.smoothappbarlayout.base.OnScrollListener;
import me.henrytao.smoothappbarlayout.base.Utils;

public class ObservableRecyclerView
implements Observer {
    public static final int HEADER_VIEW_POSITION = 0;
    private OnScrollListener mOnScrollListener;
    private RecyclerView mRecyclerView;

    public static ObservableRecyclerView newInstance(@NonNull RecyclerView recyclerView, OnScrollListener onScrollListener) {
        ObservableRecyclerView observable = new ObservableRecyclerView(recyclerView);
        observable.setOnScrollListener(onScrollListener);
        return observable;
    }

    protected ObservableRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        if (this.mRecyclerView.getTag(R.id.tag_observable_view) == null) {
            this.mRecyclerView.setTag(R.id.tag_observable_view, (Object)true);
            this.init();
        }
    }

    @Override
    public View getView() {
        return this.mRecyclerView;
    }

    @Override
    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    private void init() {
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                if (ObservableRecyclerView.this.mOnScrollListener != null) {
                    ObservableRecyclerView.this.mOnScrollListener.onScrollChanged((View)recyclerView, recyclerView.computeHorizontalScrollOffset(), recyclerView.computeVerticalScrollOffset(), dx, dy, recyclerView.getLayoutManager().findViewByPosition(0) != null);
                }
            }
        });
        this.mRecyclerView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                Utils.log("ObservableRecyclerView | %d | %d | %d | %d", left, top, right, bottom);
                ObservableRecyclerView.this.onAdapterChanged();
            }
        });
    }

    private void onAdapterChanged() {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollChanged((View)this.mRecyclerView, this.mRecyclerView.computeHorizontalScrollOffset(), this.mRecyclerView.computeVerticalScrollOffset(), 0, 0, this.mRecyclerView.getLayoutManager().findViewByPosition(0) != null);
        }
    }
}

