/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import me.henrytao.smoothappbarlayout.SmoothAppBarLayout;

public class Utils {
    public static int getActionBarSize(Context context) {
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(new int[]{16843499});
        int size = (int)styledAttributes.getDimension(0, 0.0f);
        styledAttributes.recycle();
        return size;
    }

    public static int getStatusBarSize(Context context) {
        int id2;
        int statusBarSize = 0;
        if (context != null && (id2 = context.getResources().getIdentifier("status_bar_height", "dimen", "android")) > 0) {
            statusBarSize = context.getResources().getDimensionPixelSize(id2);
        }
        return statusBarSize;
    }

    public static void intPreScroll(SmoothAppBarLayout smoothAppBarLayout, View target, int offset) {
        target.addOnLayoutChangeListener((View.OnLayoutChangeListener)new OnPreScrollListener(smoothAppBarLayout, target, offset));
    }

    public static boolean isScrollToTop(View target) {
        if (target instanceof NestedScrollView) {
            return target.getScrollY() == 0;
        }
        if (target instanceof RecyclerView) {
            return ((RecyclerView)target).getLayoutManager().findViewByPosition(0) != null && ((RecyclerView)target).computeVerticalScrollOffset() == 0;
        }
        return true;
    }

    public static void log(String s, Object ... args) {
        if (SmoothAppBarLayout.DEBUG) {
            Log.d((String)"SmoothAppBarLayout", (String)String.format(s, args));
        }
    }

    public static int parseInt(Object value) {
        if (value == null) {
            return 0;
        }
        return Integer.valueOf(value.toString());
    }

    public static boolean syncOffset(SmoothAppBarLayout smoothAppBarLayout, View target, int verticalOffset, View scroll) {
        boolean isSelected;
        boolean bl = isSelected = target == scroll;
        if (scroll instanceof NestedScrollView) {
            NestedScrollView nestedScrollView = (NestedScrollView)scroll;
            if (nestedScrollView.getScrollY() < verticalOffset || !isSelected && Utils.isScrollToTop(target)) {
                nestedScrollView.scrollTo(0, verticalOffset);
            }
            if (isSelected && (nestedScrollView.getScrollY() < verticalOffset || verticalOffset == 0)) {
                nestedScrollView.scrollTo(0, 0);
                smoothAppBarLayout.syncOffset(0);
            }
        } else if (scroll instanceof RecyclerView) {
            boolean isAccuracy;
            RecyclerView recyclerView = (RecyclerView)scroll;
            boolean bl2 = isAccuracy = recyclerView.getLayoutManager().findViewByPosition(0) != null;
            if (isAccuracy && recyclerView.computeVerticalScrollOffset() < verticalOffset) {
                recyclerView.scrollBy(0, verticalOffset - recyclerView.computeVerticalScrollOffset());
            } else if (!isSelected && Utils.isScrollToTop(target)) {
                recyclerView.scrollToPosition(0);
            }
            if (isAccuracy && isSelected && (recyclerView.computeVerticalScrollOffset() < verticalOffset || verticalOffset == 0)) {
                recyclerView.scrollToPosition(0);
                smoothAppBarLayout.syncOffset(0);
            }
        }
        return true;
    }

    private static class OnPreScrollListener
    implements View.OnLayoutChangeListener {
        private final int mOffset;
        private final SmoothAppBarLayout vSmoothAppBarLayout;
        private final View vTarget;
        private boolean mDone;

        public OnPreScrollListener(SmoothAppBarLayout smoothAppBarLayout, View target, int offset) {
            this.vSmoothAppBarLayout = smoothAppBarLayout;
            this.vTarget = target;
            this.mOffset = offset;
        }

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            int currentOffset = 0;
            if (!this.mDone) {
                if (v instanceof NestedScrollView) {
                    currentOffset = v.getScrollY();
                } else if (v instanceof RecyclerView) {
                    currentOffset = ((RecyclerView)v).computeVerticalScrollOffset();
                }
                if (currentOffset < this.mOffset) {
                    this.vTarget.scrollBy(0, this.mOffset - currentOffset);
                } else {
                    this.vSmoothAppBarLayout.syncOffset(this.mOffset);
                    this.mDone = true;
                }
            }
        }
    }
}

