/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout.base;

import android.support.annotation.NonNull;
import android.support.v4.widget.NestedScrollView;
import android.view.View;
import android.view.ViewTreeObserver;
import me.henrytao.smoothappbarlayout.R;
import me.henrytao.smoothappbarlayout.base.Observer;
import me.henrytao.smoothappbarlayout.base.OnScrollListener;
import me.henrytao.smoothappbarlayout.base.Utils;
import me.henrytao.smoothappbarlayout.widget.NestedScrollView;

public class ObservableNestedScrollView
implements Observer,
NestedScrollView.OnScrollChangeListener {
    private android.support.v4.widget.NestedScrollView mNestedScrollView;
    private OnScrollListener mOnScrollListener;
    private boolean mOverrideOnScrollListener;

    public static ObservableNestedScrollView newInstance(@NonNull android.support.v4.widget.NestedScrollView nestedScrollView, boolean overrideOnScrollListener, OnScrollListener onScrollListener) {
        ObservableNestedScrollView observable = new ObservableNestedScrollView(nestedScrollView, overrideOnScrollListener);
        observable.setOnScrollListener(onScrollListener);
        return observable;
    }

    public ObservableNestedScrollView(@NonNull android.support.v4.widget.NestedScrollView nestedScrollView, boolean overrideOnScrollListener) {
        this.mNestedScrollView = nestedScrollView;
        this.mOverrideOnScrollListener = overrideOnScrollListener;
        if (this.mNestedScrollView.getTag(R.id.tag_observable_view) == null) {
            this.mNestedScrollView.setTag(R.id.tag_observable_view, (Object)true);
            this.init();
        }
    }

    @Override
    public View getView() {
        return this.mNestedScrollView;
    }

    public void onScrollChange(android.support.v4.widget.NestedScrollView v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollChanged((View)this.mNestedScrollView, scrollX, scrollY, scrollX - oldScrollX, scrollY - oldScrollY, true);
        }
    }

    @Override
    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    private void init() {
        if (this.mNestedScrollView instanceof NestedScrollView) {
            ((NestedScrollView)this.mNestedScrollView).addOnScrollListener(this);
        } else if (this.mOverrideOnScrollListener) {
            this.mNestedScrollView.setOnScrollChangeListener((NestedScrollView.OnScrollChangeListener)this);
        } else {
            this.mNestedScrollView.getViewTreeObserver().addOnScrollChangedListener(new ViewTreeObserver.OnScrollChangedListener(){

                public void onScrollChanged() {
                    if (ObservableNestedScrollView.this.mOnScrollListener != null) {
                        int currentScrollX = ObservableNestedScrollView.this.mNestedScrollView.getScrollX();
                        int currentScrollY = ObservableNestedScrollView.this.mNestedScrollView.getScrollY();
                        ObservableNestedScrollView.this.mOnScrollListener.onScrollChanged((View)ObservableNestedScrollView.this.mNestedScrollView, currentScrollX, currentScrollY, currentScrollX - Utils.parseInt(ObservableNestedScrollView.this.mNestedScrollView.getTag(R.id.tag_observable_view_last_scroll_x)), currentScrollY - Utils.parseInt(ObservableNestedScrollView.this.mNestedScrollView.getTag(R.id.tag_observable_view_last_scroll_y)), true);
                        ObservableNestedScrollView.this.mNestedScrollView.setTag(R.id.tag_observable_view_last_scroll_x, (Object)currentScrollX);
                        ObservableNestedScrollView.this.mNestedScrollView.setTag(R.id.tag_observable_view_last_scroll_y, (Object)currentScrollY);
                    }
                }
            });
        }
    }
}

