/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout.base;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import me.henrytao.smoothappbarlayout.R;
import me.henrytao.smoothappbarlayout.base.Observer;
import me.henrytao.smoothappbarlayout.base.OnScrollListener;

public class ObservableRecyclerView
implements Observer {
    public static final int HEADER_VIEW_POSITION = 0;
    private OnScrollListener mOnScrollListener;
    private RecyclerView mRecyclerView;

    public static ObservableRecyclerView newInstance(@NonNull RecyclerView recyclerView, OnScrollListener onScrollListener) {
        ObservableRecyclerView observable = new ObservableRecyclerView(recyclerView);
        observable.setOnScrollListener(onScrollListener);
        return observable;
    }

    public ObservableRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        if (this.mRecyclerView.getTag(R.id.tag_observable_view) == null) {
            this.mRecyclerView.setTag(R.id.tag_observable_view, (Object)true);
            this.init();
        }
    }

    @Override
    public View getView() {
        return this.mRecyclerView;
    }

    @Override
    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    private void init() {
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                if (ObservableRecyclerView.this.mOnScrollListener != null) {
                    ObservableRecyclerView.this.mOnScrollListener.onScrollChanged((View)recyclerView, recyclerView.computeHorizontalScrollOffset(), recyclerView.computeVerticalScrollOffset(), dx, dy, recyclerView.getLayoutManager().findViewByPosition(0) != null);
                }
            }
        });
        this.mRecyclerView.getAdapter().registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                super.onChanged();
                ObservableRecyclerView.this.onAdapterChanged();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                ObservableRecyclerView.this.onAdapterChanged();
            }

            public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
                super.onItemRangeChanged(positionStart, itemCount, payload);
                ObservableRecyclerView.this.onAdapterChanged();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                ObservableRecyclerView.this.onAdapterChanged();
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                ObservableRecyclerView.this.onAdapterChanged();
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                super.onItemRangeRemoved(positionStart, itemCount);
                ObservableRecyclerView.this.onAdapterChanged();
            }
        });
    }

    private void onAdapterChanged() {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollChanged((View)this.mRecyclerView, this.mRecyclerView.computeHorizontalScrollOffset(), this.mRecyclerView.computeVerticalScrollOffset(), 0, 0, this.mRecyclerView.getLayoutManager().findViewByPosition(0) != null);
        }
    }
}

