/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.henrytao.smoothappbarlayout.BaseBehavior;
import me.henrytao.smoothappbarlayout.OnOffsetSyncedListener;
import me.henrytao.smoothappbarlayout.PagerAdapter;
import me.henrytao.smoothappbarlayout.R;
import me.henrytao.smoothappbarlayout.ScrollFlag;
import me.henrytao.smoothappbarlayout.ScrollState;
import me.henrytao.smoothappbarlayout.utils.ResourceUtils;

@CoordinatorLayout.DefaultBehavior(value=Behavior.class)
public class SmoothAppBarLayout
extends AppBarLayout {
    protected static final int FAKE_DELAY = 120;
    protected final List<WeakReference<AppBarLayout.OnOffsetChangedListener>> mOffsetChangedListeners = new ArrayList<WeakReference<AppBarLayout.OnOffsetChangedListener>>();
    protected final List<WeakReference<OnOffsetSyncedListener>> mOffsetSyncedListeners = new ArrayList<WeakReference<OnOffsetSyncedListener>>();
    protected boolean mHaveChildWithInterpolator;
    protected int mViewPagerId;
    protected ViewPager vViewPager;

    public SmoothAppBarLayout(Context context) {
        super(context);
        this.init(null);
    }

    public SmoothAppBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public void addOnOffsetChangedListener(AppBarLayout.OnOffsetChangedListener listener) {
        super.addOnOffsetChangedListener(listener);
        int z = this.mOffsetChangedListeners.size();
        for (int i = 0; i < z; ++i) {
            WeakReference<AppBarLayout.OnOffsetChangedListener> ref = this.mOffsetChangedListeners.get(i);
            if (ref == null || ref.get() != listener) continue;
            return;
        }
        this.mOffsetChangedListeners.add(new WeakReference<AppBarLayout.OnOffsetChangedListener>(listener));
    }

    public void removeOnOffsetChangedListener(AppBarLayout.OnOffsetChangedListener listener) {
        super.removeOnOffsetChangedListener(listener);
        Iterator<WeakReference<AppBarLayout.OnOffsetChangedListener>> i = this.mOffsetChangedListeners.iterator();
        while (i.hasNext()) {
            WeakReference<AppBarLayout.OnOffsetChangedListener> ref = i.next();
            AppBarLayout.OnOffsetChangedListener item = (AppBarLayout.OnOffsetChangedListener)ref.get();
            if (item != listener && item != null) continue;
            i.remove();
        }
        return;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.initViews();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            AppBarLayout.LayoutParams childLp = (AppBarLayout.LayoutParams)child.getLayoutParams();
            Interpolator interpolator = childLp.getScrollInterpolator();
            if (interpolator == null) continue;
            this.mHaveChildWithInterpolator = true;
            break;
        }
    }

    public void addOnOffsetSyncedListener(OnOffsetSyncedListener listener) {
        int z = this.mOffsetSyncedListeners.size();
        for (int i = 0; i < z; ++i) {
            WeakReference<OnOffsetSyncedListener> ref = this.mOffsetSyncedListeners.get(i);
            if (ref == null || ref.get() != listener) continue;
            return;
        }
        this.mOffsetSyncedListeners.add(new WeakReference<OnOffsetSyncedListener>(listener));
    }

    public ViewPager getViewPager() {
        return this.vViewPager;
    }

    public void removeOnOffsetSyncedListener(OnOffsetSyncedListener listener) {
        Iterator<WeakReference<OnOffsetSyncedListener>> i = this.mOffsetSyncedListeners.iterator();
        while (i.hasNext()) {
            WeakReference<OnOffsetSyncedListener> ref = i.next();
            OnOffsetSyncedListener item = (OnOffsetSyncedListener)ref.get();
            if (item != listener && item != null) continue;
            i.remove();
        }
        return;
    }

    public void syncOffset() {
        int z = this.mOffsetSyncedListeners.size();
        for (int i = 0; i < z; ++i) {
            OnOffsetSyncedListener listener;
            WeakReference<OnOffsetSyncedListener> ref = this.mOffsetSyncedListeners.get(i);
            OnOffsetSyncedListener onOffsetSyncedListener = listener = ref != null ? (OnOffsetSyncedListener)ref.get() : null;
            if (listener == null) continue;
            listener.onOffsetSynced(this);
        }
    }

    public void syncOffsetDelayed(int delayMillis) {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                SmoothAppBarLayout.this.syncOffset();
            }
        }, delayMillis);
    }

    public void syncOffsetDelayed() {
        this.syncOffsetDelayed(120);
    }

    protected void init(AttributeSet attrs) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SmoothAppBarLayout, 0, 0);
        try {
            this.mViewPagerId = a.getResourceId(R.styleable.SmoothAppBarLayout_sabl_view_pager_id, 0);
        }
        finally {
            a.recycle();
        }
    }

    protected void initViews() {
        if (this.mViewPagerId > 0) {
            this.vViewPager = (ViewPager)this.getRootView().findViewById(this.mViewPagerId);
        } else {
            ViewGroup parent = (ViewGroup)this.getParent();
            int z = parent.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = parent.getChildAt(i);
                if (!(child instanceof ViewPager)) continue;
                this.vViewPager = (ViewPager)child;
                break;
            }
        }
    }

    public static class Behavior
    extends BaseBehavior {
        protected int mCurrentScrollOffset;
        protected int mCurrentTranslationOffset;
        protected int mQuickReturnOffset;
        protected ScrollFlag mScrollFlag;
        protected int mStatusBarSize;
        protected int mViewPagerScrollOffset;
        protected Map<Integer, ScrollState> mViewPagerScrollStates = new HashMap<Integer, ScrollState>();
        protected ViewPager vViewPager;

        private static void log(String s, Object ... args) {
        }

        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        @Override
        protected int getCurrentScrollOffset() {
            return this.mCurrentScrollOffset;
        }

        @Override
        protected void onInit(CoordinatorLayout coordinatorLayout, AppBarLayout child) {
            if (this.mScrollFlag == null) {
                this.mScrollFlag = new ScrollFlag(child);
            }
        }

        @Override
        protected void onScrollChanged(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dy) {
            if (dy != 0) {
                int minTranslationOffset = this.getMinOffset(child);
                int maxTranslationOffset = this.getMaxOffset(child);
                this.mCurrentScrollOffset = Math.max(this.mCurrentScrollOffset + dy, 0);
                this.mViewPagerScrollOffset = Math.max(this.mViewPagerScrollOffset + dy, 0);
                int translationOffset = Math.min(Math.max(-this.mCurrentScrollOffset, minTranslationOffset), maxTranslationOffset);
                if (this.mScrollFlag != null && this.mScrollFlag.isQuickReturnEnabled()) {
                    if (translationOffset == 0) {
                        this.mQuickReturnOffset = 0;
                    }
                    if (translationOffset == minTranslationOffset) {
                        this.mQuickReturnOffset = dy < 0 ? Math.max(this.mQuickReturnOffset + dy, -ViewCompat.getMinimumHeight((View)this.mScrollFlag.getView())) : Math.min(this.mQuickReturnOffset + dy, 0);
                        translationOffset -= this.mQuickReturnOffset;
                    } else {
                        translationOffset = Math.min(Math.max(translationOffset - this.mQuickReturnOffset, minTranslationOffset), maxTranslationOffset);
                    }
                }
                Behavior.log("onScrollChanged | %d | %d | %d | %d | %d | %d | %d", dy, this.mCurrentScrollOffset, this.mViewPagerScrollOffset, this.mQuickReturnOffset, translationOffset, minTranslationOffset, maxTranslationOffset);
                this.scrolling(coordinatorLayout, child, target, translationOffset);
                this.onViewPagerPropagateScrollState(coordinatorLayout, child, target, dy, Math.abs(translationOffset));
            }
        }

        @Override
        protected void onSyncOffset(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target) {
            int newOffset = this.mCurrentScrollOffset;
            if (target instanceof RecyclerView) {
                newOffset = ((RecyclerView)target).computeVerticalScrollOffset();
            }
            Behavior.log("custom onSyncOffset | %d | %d", this.mCurrentScrollOffset, newOffset);
            this.onScrollChanged(coordinatorLayout, child, target, newOffset - this.mCurrentScrollOffset);
        }

        @Override
        protected void onViewPagerSelected(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, ViewPager viewPager, int position) {
            this.vViewPager = viewPager;
            if (!this.mViewPagerScrollStates.containsKey(position)) {
                this.mViewPagerScrollStates.put(position, new ScrollState());
            }
            this.mViewPagerScrollOffset = this.mViewPagerScrollStates.get(position).getOffset();
            this.mCurrentScrollOffset = Math.abs(this.mCurrentTranslationOffset);
            Behavior.log("onViewPagerSelected | %d | %d | %d", position, this.mCurrentScrollOffset, this.mViewPagerScrollOffset);
            this.onViewPagerPropagateScrollState(coordinatorLayout, child, target);
        }

        @Override
        protected void scrolling(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int offset) {
            super.scrolling(coordinatorLayout, child, target, offset);
            this.mCurrentTranslationOffset = offset;
        }

        protected int getMaxOffset(AppBarLayout layout) {
            return 0;
        }

        protected int getMinOffset(AppBarLayout layout) {
            int minOffset = layout.getMeasuredHeight();
            if (this.mScrollFlag != null) {
                if (this.mScrollFlag.isFlagScrollEnabled()) {
                    minOffset = this.mScrollFlag.getView().getMeasuredHeight();
                }
                if (this.mScrollFlag.isFlagExitUntilCollapsedEnabled()) {
                    minOffset -= ViewCompat.getMinimumHeight((View)this.mScrollFlag.getView());
                }
            }
            if (ViewCompat.getFitsSystemWindows((View)layout)) {
                if (this.mStatusBarSize == 0) {
                    this.mStatusBarSize = ResourceUtils.getStatusBarSize(layout.getContext());
                }
                minOffset -= this.mStatusBarSize;
            }
            return -minOffset;
        }

        protected void onViewPagerPropagateScrollState(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dy, int offset) {
            this.onViewPagerPropagateScrollState(coordinatorLayout, child, target, dy, offset, false, false);
        }

        protected void onViewPagerPropagateScrollState(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dy, int offset, boolean isPropagateOnly, boolean isIncludeCurrentTarget) {
            if (this.vViewPager != null && this.vViewPager.getAdapter() instanceof PagerAdapter) {
                PagerAdapter adapter = (PagerAdapter)this.vViewPager.getAdapter();
                int n = this.vViewPager.getAdapter().getCount();
                for (int i = 0; i < n; ++i) {
                    View scrollView = adapter.getScrollView(i);
                    if (!this.mViewPagerScrollStates.containsKey(i)) {
                        this.mViewPagerScrollStates.put(i, new ScrollState());
                    }
                    if (!isPropagateOnly) {
                        int scrollOffset = offset;
                        if (scrollView instanceof RecyclerView) {
                            scrollOffset = ((RecyclerView)scrollView).computeVerticalScrollOffset();
                        } else if (scrollView instanceof NestedScrollView) {
                            scrollOffset = scrollView.getScrollY();
                        }
                        this.mViewPagerScrollStates.get(i).setOffset(scrollOffset, offset);
                        if (offset == 0) {
                            this.mViewPagerScrollStates.get(i).reset();
                        }
                        if (scrollView == target) {
                            this.mViewPagerScrollStates.get(i).setState(ScrollState.State.SCROLLED);
                        }
                    }
                    if (scrollView != target || isIncludeCurrentTarget) {
                        this.onViewPagerSyncOffset(coordinatorLayout, child, target, this.vViewPager.getAdapter(), i, this.mViewPagerScrollStates.get(i).getOffset());
                    }
                    Behavior.log("onViewPagerPropagateScrollState | %d | %b | %b | %d", i, scrollView != null, scrollView != target, this.mViewPagerScrollStates.get(i).getOffset());
                }
            }
        }

        protected void onViewPagerPropagateScrollState(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target) {
            this.onViewPagerPropagateScrollState(coordinatorLayout, child, target, 0, 0, true, true);
        }

        protected void onViewPagerReset() {
            int n = this.mViewPagerScrollStates.size();
            for (int i = 0; i < n; ++i) {
                this.mViewPagerScrollStates.get(i).reset();
            }
        }

        protected void onViewPagerSyncOffset(final CoordinatorLayout coordinatorLayout, final AppBarLayout child, final View target, final android.support.v4.view.PagerAdapter adapter, final int position, final int offset) {
            if (adapter instanceof PagerAdapter.OnSyncOffset) {
                int delay = ((PagerAdapter.OnSyncOffset)adapter).onSyncOffset(position, offset);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Behavior.this.onViewPagerSyncOffsetCallback(coordinatorLayout, child, target, adapter, position, offset);
                    }
                }, (long)delay);
            } else if (adapter instanceof PagerAdapter.OnSyncOffsetRunnable) {
                ((PagerAdapter.OnSyncOffsetRunnable)adapter).onSyncOffset(position, offset, new Runnable(){

                    @Override
                    public void run() {
                        Behavior.this.onViewPagerSyncOffsetCallback(coordinatorLayout, child, target, adapter, position, offset);
                    }
                });
            }
        }

        protected void onViewPagerSyncOffsetCallback(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, android.support.v4.view.PagerAdapter adapter, int position, int offset) {
            if (adapter instanceof PagerAdapter) {
                int scrollOffset = offset;
                View scrollView = ((PagerAdapter)adapter).getScrollView(position);
                if (scrollView != null && scrollView == target) {
                    if (scrollView instanceof RecyclerView) {
                        scrollOffset = ((RecyclerView)scrollView).computeVerticalScrollOffset();
                    } else if (scrollView instanceof NestedScrollView) {
                        scrollOffset = scrollView.getScrollY();
                    }
                    Behavior.log("onViewPagerSyncOffsetCallback | %d | %d | %d", position, offset, scrollOffset);
                    if (scrollOffset < offset) {
                        this.scrolling(coordinatorLayout, child, target, 0);
                        this.onViewPagerReset();
                    }
                }
            }
        }
    }
}

