/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout;

public class ScrollState {
    private int mIdealOffset;
    private int mOffset = 0;
    private State mState = State.DEFAULT;

    public int getOffset() {
        if (this.mState == State.DEFAULT) {
            return this.mIdealOffset;
        }
        return Math.max(this.mOffset, this.mIdealOffset);
    }

    public void reset() {
        this.mState = State.DEFAULT;
        this.mOffset = 0;
        this.mIdealOffset = 0;
    }

    public void setOffset(int offset, int idealOffset) {
        this.mOffset = this.mState == State.SCROLLED ? Math.max(this.mOffset, offset) : offset;
        this.mIdealOffset = idealOffset;
    }

    public void setState(State state) {
        this.mState = state;
        if (this.mState == State.DEFAULT) {
            this.mOffset = 0;
        }
    }

    public static enum State {
        DEFAULT,
        SCROLLED;

    }
}

