/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout;

import android.support.design.widget.AppBarLayout;
import android.view.View;
import android.view.ViewGroup;

public class ScrollFlag {
    private int mFlags;
    private View vView;

    public ScrollFlag(AppBarLayout layout) {
        if (layout != null) {
            int z = layout.getChildCount();
            for (int i = 0; i < z; ++i) {
                AppBarLayout.LayoutParams childLp;
                int flags;
                View child = layout.getChildAt(i);
                ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                if (!(layoutParams instanceof AppBarLayout.LayoutParams) || ((flags = (childLp = (AppBarLayout.LayoutParams)layoutParams).getScrollFlags()) & 1) == 0) continue;
                this.vView = child;
                this.mFlags = flags;
                break;
            }
        }
    }

    public View getView() {
        return this.vView;
    }

    public boolean isFlagEnterAlwaysCollapsedEnabled() {
        return this.vView != null && (this.mFlags & 4) != 0;
    }

    public boolean isFlagEnterAlwaysEnabled() {
        return this.vView != null && (this.mFlags & 8) != 0;
    }

    public boolean isFlagExitUntilCollapsedEnabled() {
        return this.vView != null && (this.mFlags & 2) != 0;
    }

    public boolean isFlagScrollEnabled() {
        return this.vView != null && (this.mFlags & 1) != 0;
    }

    public boolean isQuickReturnEnabled() {
        return this.isFlagEnterAlwaysEnabled() && this.isFlagEnterAlwaysCollapsedEnabled();
    }
}

