/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout;

import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.ViewPager;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import me.henrytao.smoothappbarlayout.OnOffsetSyncedListener;
import me.henrytao.smoothappbarlayout.PagerAdapter;
import me.henrytao.smoothappbarlayout.R;
import me.henrytao.smoothappbarlayout.SmoothAppBarLayout;
import me.henrytao.smoothappbarlayout.widget.NestedScrollView;

public abstract class BaseBehavior
extends AppBarLayout.Behavior {
    protected List<Long> mScrollTargets = new ArrayList<Long>();
    private boolean mIsOnInit = false;
    private boolean mIsPullDownFromTop;
    private OnOffsetSyncedListener mOnOffsetSyncedListener;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private View vScrollTarget;
    private ViewPager vViewPager;

    protected abstract int getCurrentScrollOffset();

    protected abstract void onInit(CoordinatorLayout var1, AppBarLayout var2);

    protected abstract void onScrollChanged(CoordinatorLayout var1, AppBarLayout var2, View var3, int var4);

    protected abstract void onSyncOffset(CoordinatorLayout var1, AppBarLayout var2, View var3);

    protected abstract void onViewPagerSelected(CoordinatorLayout var1, AppBarLayout var2, View var3, ViewPager var4, int var5);

    private static void log(String s, Object ... args) {
    }

    public BaseBehavior() {
    }

    public BaseBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean onMeasureChild(CoordinatorLayout coordinatorLayout, AppBarLayout child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        if (!this.mIsOnInit && coordinatorLayout != null && child != null) {
            this.mIsOnInit = true;
            this.init(coordinatorLayout, child);
        }
        return super.onMeasureChild(coordinatorLayout, (View)child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    public boolean onNestedFling(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, float velocityX, float velocityY, boolean consumed) {
        BaseBehavior.log("onNestedFling | %f | %f | %b", Float.valueOf(velocityX), Float.valueOf(velocityY), consumed);
        return true;
    }

    public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, float velocityX, float velocityY) {
        BaseBehavior.log("onNestedPreFling | %f | %f", Float.valueOf(velocityX), Float.valueOf(velocityY));
        return false;
    }

    public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dx, int dy, int[] consumed) {
        BaseBehavior.log("onNestedPreScroll | %d | %d", dx, dy);
        if (this.vViewPager == null) {
            this.vScrollTarget = this.getScrollTarget(target);
        }
        this.onScrollChanged(coordinatorLayout, child);
        if (dy < 0 && this.mIsPullDownFromTop) {
            this.onScrollChanged(coordinatorLayout, child, this.vScrollTarget, dy);
        }
    }

    public void onNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        BaseBehavior.log("onNestedScroll | %d | %d | %d | %d", dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
        this.mIsPullDownFromTop = dyUnconsumed < 0;
    }

    public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, AppBarLayout child, View directTargetChild, View target, int nestedScrollAxes) {
        BaseBehavior.log("onNestedScrollAccepted | %d", nestedScrollAxes);
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View directTargetChild, View target, int nestedScrollAxes) {
        BaseBehavior.log("onStartNestedScroll | %d", nestedScrollAxes);
        return true;
    }

    public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target) {
        BaseBehavior.log("onStopNestedScroll", new Object[0]);
    }

    protected void dispatchOffsetUpdates(AppBarLayout layout, int translationOffset) {
        if (layout instanceof SmoothAppBarLayout) {
            List<WeakReference<AppBarLayout.OnOffsetChangedListener>> listeners = ((SmoothAppBarLayout)layout).mOffsetChangedListeners;
            int z = listeners.size();
            for (int i = 0; i < z; ++i) {
                AppBarLayout.OnOffsetChangedListener listener;
                WeakReference<AppBarLayout.OnOffsetChangedListener> ref = listeners.get(i);
                AppBarLayout.OnOffsetChangedListener onOffsetChangedListener = listener = ref != null ? (AppBarLayout.OnOffsetChangedListener)ref.get() : null;
                if (listener == null) continue;
                listener.onOffsetChanged(layout, translationOffset);
            }
        }
    }

    protected void scrolling(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int offset) {
        BaseBehavior.log("scrolling | %d", offset);
        this.setTopAndBottomOffset(offset);
        if (child instanceof SmoothAppBarLayout && ((SmoothAppBarLayout)child).mHaveChildWithInterpolator) {
            coordinatorLayout.dispatchDependentViewsChanged((View)child);
        }
        this.dispatchOffsetUpdates(child, offset);
    }

    private View getScrollTarget(View target) {
        if (target instanceof SwipeRefreshLayout && ((SwipeRefreshLayout)target).getChildCount() > 0) {
            return ((SwipeRefreshLayout)target).getChildAt(0);
        }
        return target;
    }

    private long getViewTag(View target, boolean createIfNotExist) {
        if (target == null) {
            return 0L;
        }
        Object tag = target.getTag(R.id.tag_view_target);
        if (tag == null) {
            if (!createIfNotExist) {
                return 0L;
            }
            tag = System.currentTimeMillis();
            target.setTag(R.id.tag_view_target, tag);
        }
        return (Long)tag;
    }

    private void init(final CoordinatorLayout coordinatorLayout, final AppBarLayout child) {
        if (this.mOnOffsetSyncedListener == null && child instanceof SmoothAppBarLayout) {
            this.mOnOffsetSyncedListener = new OnOffsetSyncedListener(){

                @Override
                public void onOffsetSynced(AppBarLayout appBarLayout) {
                    BaseBehavior.this.onSyncOffset(coordinatorLayout, child);
                }
            };
            ((SmoothAppBarLayout)child).addOnOffsetSyncedListener(this.mOnOffsetSyncedListener);
        }
        if (this.mOnPageChangeListener == null && child instanceof SmoothAppBarLayout) {
            this.mOnPageChangeListener = new ViewPager.OnPageChangeListener(){

                public void onPageScrollStateChanged(int state) {
                }

                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                }

                public void onPageSelected(int position) {
                    BaseBehavior.this.onViewPagerSelected(coordinatorLayout, child, position);
                }
            };
            this.vViewPager = ((SmoothAppBarLayout)child).getViewPager();
            if (this.vViewPager != null) {
                this.vViewPager.addOnPageChangeListener(this.mOnPageChangeListener);
                this.onViewPagerSelected(coordinatorLayout, child, this.vViewPager.getCurrentItem());
            }
        }
        this.onInit(coordinatorLayout, child);
    }

    private void initNestedScrollView(final CoordinatorLayout coordinatorLayout, final AppBarLayout child, final NestedScrollView target) {
        BaseBehavior.log("initNestedScrollView", new Object[0]);
        target.addOnScrollListener(new NestedScrollView.OnScrollListener(){

            @Override
            public void onScrolled(android.support.v4.widget.NestedScrollView nestedScrollView, int dx, int dy) {
                if (target == BaseBehavior.this.vScrollTarget) {
                    BaseBehavior.this.onScrollChanged(coordinatorLayout, child, (View)target, dy);
                }
            }
        });
    }

    private void initRecyclerView(final CoordinatorLayout coordinatorLayout, final AppBarLayout child, final RecyclerView target) {
        BaseBehavior.log("initRecyclerView", new Object[0]);
        target.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                if (target == BaseBehavior.this.vScrollTarget) {
                    BaseBehavior.this.onScrollChanged(coordinatorLayout, child, (View)target, dy);
                }
            }
        });
    }

    private void initViewTreeObserver(final CoordinatorLayout coordinatorLayout, final AppBarLayout child, final View target) {
        BaseBehavior.log("initViewTreeObserver", new Object[0]);
        target.getViewTreeObserver().addOnScrollChangedListener(new ViewTreeObserver.OnScrollChangedListener(){

            public void onScrollChanged() {
                if (target == BaseBehavior.this.vScrollTarget) {
                    BaseBehavior.this.onScrollChanged(coordinatorLayout, child, target, target.getScrollY() - BaseBehavior.this.getCurrentScrollOffset());
                }
            }
        });
    }

    private void onScrollChanged(CoordinatorLayout coordinatorLayout, AppBarLayout child) {
        long tag;
        BaseBehavior.log("onScrollChanged | %b", this.vScrollTarget != null);
        if (this.vScrollTarget != null && !this.mScrollTargets.contains(tag = this.getViewTag(this.vScrollTarget, true))) {
            this.mScrollTargets.add(tag);
            if (this.vScrollTarget instanceof RecyclerView) {
                this.initRecyclerView(coordinatorLayout, child, (RecyclerView)this.vScrollTarget);
            } else if (this.vScrollTarget instanceof NestedScrollView) {
                this.initNestedScrollView(coordinatorLayout, child, (NestedScrollView)this.vScrollTarget);
            } else {
                this.initViewTreeObserver(coordinatorLayout, child, this.vScrollTarget);
            }
        }
    }

    private void onSyncOffset(CoordinatorLayout coordinatorLayout, AppBarLayout child) {
        BaseBehavior.log("onSyncOffset | %b", this.vScrollTarget != null);
        if (this.vScrollTarget != null) {
            this.onSyncOffset(coordinatorLayout, child, this.vScrollTarget);
        }
    }

    private void onViewPagerSelected(CoordinatorLayout coordinatorLayout, AppBarLayout child, int position) {
        BaseBehavior.log("onSyncOffset | %b", this.vViewPager.getAdapter() instanceof PagerAdapter);
        if (this.vViewPager.getAdapter() instanceof PagerAdapter) {
            PagerAdapter adapter = (PagerAdapter)this.vViewPager.getAdapter();
            this.vScrollTarget = this.getScrollTarget(adapter.getScrollView(position));
            this.onViewPagerSelected(coordinatorLayout, child, this.vScrollTarget, this.vViewPager, position);
        }
    }
}

