/*
 * Decompiled with CFR 0.152.
 */
package me.gujun.android.span;

import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.view.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.gujun.android.span.style.CustomTypefaceSpan;
import me.gujun.android.span.style.LineSpacingSpan;
import me.gujun.android.span.style.TextDecorationLineSpan;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 G2\u00020\u0001:\u0001GB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010?\u001a\u00020\u0000J \u0010@\u001a\u00020\u00152\u0016\u0010A\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001fH\u0002J \u0010B\u001a\u00020\u00152\u0016\u0010A\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001fH\u0002J\u0006\u0010C\u001a\u00020\u0015J\u0015\u0010D\u001a\u00020%*\u00020\u00002\u0006\u0010E\u001a\u00020%H\u0086\u0002J\r\u0010F\u001a\u00020%*\u00020%H\u0086\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\"\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR*\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\r\"\u0004\b,\u0010\u000fR\u001e\u0010-\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0007\"\u0004\b/\u0010\tR\u001a\u00100\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\r\"\u0004\b2\u0010\u000fR\u001e\u00103\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0007\"\u0004\b5\u0010\tR\u001a\u00106\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\r\"\u0004\b8\u0010\u000fR\u001c\u00109\u001a\u0004\u0018\u00010:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006H"}, d2={"Lme/gujun/android/span/Span;", "Landroid/text/SpannableStringBuilder;", "parent", "(Lme/gujun/android/span/Span;)V", "backgroundColor", "", "getBackgroundColor", "()I", "setBackgroundColor", "(I)V", "fontFamily", "", "getFontFamily", "()Ljava/lang/String;", "setFontFamily", "(Ljava/lang/String;)V", "lineSpacing", "getLineSpacing", "setLineSpacing", "onClick", "Lkotlin/Function0;", "", "getOnClick", "()Lkotlin/jvm/functions/Function0;", "setOnClick", "(Lkotlin/jvm/functions/Function0;)V", "getParent", "()Lme/gujun/android/span/Span;", "styles", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getStyles", "()Ljava/util/ArrayList;", "setStyles", "(Ljava/util/ArrayList;)V", "text", "", "getText", "()Ljava/lang/CharSequence;", "setText", "(Ljava/lang/CharSequence;)V", "textAlign", "getTextAlign", "setTextAlign", "textColor", "getTextColor", "setTextColor", "textDecorationLine", "getTextDecorationLine", "setTextDecorationLine", "textSize", "getTextSize", "setTextSize", "textStyle", "getTextStyle", "setTextStyle", "typeface", "Landroid/graphics/Typeface;", "getTypeface", "()Landroid/graphics/Typeface;", "setTypeface", "(Landroid/graphics/Typeface;)V", "build", "buildCharacterStyle", "builder", "buildParagraphStyle", "setGlobalStyles", "plus", "other", "unaryPlus", "Companion", "span_release"})
public final class Span
extends SpannableStringBuilder {
    @NotNull
    private CharSequence text;
    @ColorInt
    private int textColor;
    @ColorInt
    private int backgroundColor;
    @Dimension(unit=1)
    private int textSize;
    @NotNull
    private String fontFamily;
    @Nullable
    private Typeface typeface;
    @NotNull
    private String textStyle;
    @NotNull
    private String textAlign;
    @NotNull
    private String textDecorationLine;
    @Dimension(unit=1)
    private int lineSpacing;
    @Nullable
    private Function0<Unit> onClick;
    @NotNull
    private ArrayList<Object> styles;
    @Nullable
    private final Span parent;
    private static final int UNSPECIFIED = -1;
    @NotNull
    private static final ArrayList<Object> globalStyles;
    public static final Companion Companion;

    @NotNull
    public final CharSequence getText() {
        return this.text;
    }

    public final void setText(@NotNull CharSequence charSequence) {
        Intrinsics.checkParameterIsNotNull((Object)charSequence, (String)"<set-?>");
        this.text = charSequence;
    }

    public final int getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(int n) {
        this.textColor = n;
    }

    public final int getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(int n) {
        this.backgroundColor = n;
    }

    public final int getTextSize() {
        return this.textSize;
    }

    public final void setTextSize(int n) {
        this.textSize = n;
    }

    @NotNull
    public final String getFontFamily() {
        return this.fontFamily;
    }

    public final void setFontFamily(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.fontFamily = string;
    }

    @Nullable
    public final Typeface getTypeface() {
        return this.typeface;
    }

    public final void setTypeface(@Nullable Typeface typeface) {
        this.typeface = typeface;
    }

    @NotNull
    public final String getTextStyle() {
        return this.textStyle;
    }

    public final void setTextStyle(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.textStyle = string;
    }

    @NotNull
    public final String getTextAlign() {
        return this.textAlign;
    }

    public final void setTextAlign(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.textAlign = string;
    }

    @NotNull
    public final String getTextDecorationLine() {
        return this.textDecorationLine;
    }

    public final void setTextDecorationLine(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.textDecorationLine = string;
    }

    public final int getLineSpacing() {
        return this.lineSpacing;
    }

    public final void setLineSpacing(int n) {
        this.lineSpacing = n;
    }

    @Nullable
    public final Function0<Unit> getOnClick() {
        return this.onClick;
    }

    public final void setOnClick(@Nullable Function0<Unit> function0) {
        this.onClick = function0;
    }

    @NotNull
    public final ArrayList<Object> getStyles() {
        return this.styles;
    }

    public final void setStyles(@NotNull ArrayList<Object> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.styles = arrayList;
    }

    private final void buildCharacterStyle(ArrayList<Object> builder) {
        if (this.textColor != Companion.getUNSPECIFIED()) {
            builder.add(new ForegroundColorSpan(this.textColor));
        }
        if (this.backgroundColor != Companion.getUNSPECIFIED()) {
            builder.add(new BackgroundColorSpan(this.backgroundColor));
        }
        if (this.textSize != Companion.getUNSPECIFIED()) {
            builder.add(new AbsoluteSizeSpan(this.textSize));
        }
        if (!TextUtils.isEmpty((CharSequence)this.fontFamily)) {
            builder.add(new TypefaceSpan(this.fontFamily));
        }
        if (this.typeface != null) {
            Typeface typeface = this.typeface;
            if (typeface == null) {
                Intrinsics.throwNpe();
            }
            builder.add((Object)new CustomTypefaceSpan(typeface));
        }
        if (!TextUtils.isEmpty((CharSequence)this.textStyle)) {
            int n;
            switch (this.textStyle) {
                case "normal": {
                    n = 0;
                    break;
                }
                case "bold": {
                    n = 1;
                    break;
                }
                case "italic": {
                    n = 2;
                    break;
                }
                case "bold_italic": {
                    n = 3;
                    break;
                }
                default: {
                    throw (Throwable)new RuntimeException("Unknown text style");
                }
            }
            builder.add(new StyleSpan(n));
        }
        if (!TextUtils.isEmpty((CharSequence)this.textDecorationLine)) {
            builder.add((Object)new TextDecorationLineSpan(this.textDecorationLine));
        }
        if (this.onClick != null) {
            builder.add(new ClickableSpan(this){
                final /* synthetic */ Span this$0;

                public void onClick(@NotNull View widget) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
                        Function0<Unit> function0 = this.this$0.getOnClick();
                        if (function0 == null) break block0;
                        Unit cfr_ignored_0 = (Unit)function0.invoke();
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    private final void buildParagraphStyle(ArrayList<Object> builder) {
        if (!TextUtils.isEmpty((CharSequence)this.textAlign)) {
            Layout.Alignment alignment;
            switch (this.textAlign) {
                case "normal": {
                    alignment = Layout.Alignment.ALIGN_NORMAL;
                    break;
                }
                case "opposite": {
                    alignment = Layout.Alignment.ALIGN_OPPOSITE;
                    break;
                }
                case "center": {
                    alignment = Layout.Alignment.ALIGN_CENTER;
                    break;
                }
                default: {
                    throw (Throwable)new RuntimeException("Unknown text alignment");
                }
            }
            builder.add(new AlignmentSpan.Standard(alignment));
        }
        if (this.lineSpacing != Companion.getUNSPECIFIED()) {
            builder.add(new LineSpacingSpan(this.lineSpacing));
        }
    }

    @NotNull
    public final Span build() {
        ArrayList<Object> spans = new ArrayList<Object>();
        if (!TextUtils.isEmpty((CharSequence)this.text)) {
            Span p = this.parent;
            while (p != null) {
                if (!TextUtils.isEmpty((CharSequence)p.text)) {
                    throw (Throwable)new RuntimeException("Can't nest \"" + this.text + "\" in spans");
                }
                p = p.parent;
            }
            this.append(this.text);
            this.buildCharacterStyle(spans);
            this.buildParagraphStyle(spans);
        } else {
            this.buildParagraphStyle(spans);
        }
        spans.addAll((Collection<Object>)this.styles);
        Iterable $receiver$iv = spans;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            this.setSpan(it, 0, this.length(), 33);
        }
        return this;
    }

    public final void setGlobalStyles() {
        Iterable $receiver$iv = Companion.getGlobalStyles();
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            this.setSpan(it, 0, this.length(), 18);
        }
    }

    @NotNull
    public final CharSequence unaryPlus(@NotNull CharSequence $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Span span2 = new Span(this);
        Span span3 = this;
        Span $receiver2 = span2;
        $receiver2.text = $receiver;
        $receiver2.build();
        Span span4 = span2;
        SpannableStringBuilder spannableStringBuilder = span3.append((CharSequence)((Object)span4));
        Intrinsics.checkExpressionValueIsNotNull((Object)spannableStringBuilder, (String)"append(Span(parent = thi\u2026Plus\n      build()\n    })");
        return (CharSequence)spannableStringBuilder;
    }

    @NotNull
    public final CharSequence plus(@NotNull Span $receiver, @NotNull CharSequence other) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Span span2 = new Span(this);
        Span span3 = $receiver;
        Span $receiver2 = span2;
        $receiver2.text = other;
        $receiver2.build();
        Span span4 = span2;
        SpannableStringBuilder spannableStringBuilder = span3.append((CharSequence)((Object)span4));
        Intrinsics.checkExpressionValueIsNotNull((Object)spannableStringBuilder, (String)"append(Span(parent = thi\u2026ther\n      build()\n    })");
        return (CharSequence)spannableStringBuilder;
    }

    @Nullable
    public final Span getParent() {
        return this.parent;
    }

    public Span(@Nullable Span parent) {
        Object object;
        Object object2;
        this.parent = parent;
        this.text = "";
        Span span2 = this.parent;
        this.textColor = span2 != null ? span2.textColor : Companion.getUNSPECIFIED();
        Span span3 = this.parent;
        this.backgroundColor = span3 != null ? span3.backgroundColor : Companion.getUNSPECIFIED();
        Span span4 = this.parent;
        this.textSize = span4 != null ? span4.textSize : Companion.getUNSPECIFIED();
        Object object3 = this.parent;
        if (object3 == null || (object3 = object3.fontFamily) == null) {
            object3 = "";
        }
        this.fontFamily = object3;
        Span span5 = this.parent;
        this.typeface = span5 != null ? span5.typeface : null;
        Object object4 = this.parent;
        if (object4 == null || (object4 = object4.textStyle) == null) {
            object4 = this.textStyle = "";
        }
        if ((object2 = this.parent) == null || (object2 = object2.textAlign) == null) {
            object2 = this.textAlign = "";
        }
        if ((object = this.parent) == null || (object = object.textDecorationLine) == null) {
            object = "";
        }
        this.textDecorationLine = object;
        this.lineSpacing = Companion.getUNSPECIFIED();
        Span span6 = this;
        ArrayList arrayList = new ArrayList();
        span6.styles = arrayList;
    }

    public /* synthetic */ Span(Span span2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            span2 = null;
        }
        this(span2);
    }

    public Span() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        UNSPECIFIED = -1;
        globalStyles = new ArrayList();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00010\bj\b\u0012\u0004\u0012\u00020\u0001`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lme/gujun/android/span/Span$Companion;", "", "()V", "UNSPECIFIED", "", "getUNSPECIFIED", "()I", "globalStyles", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getGlobalStyles", "()Ljava/util/ArrayList;", "span_release"})
    public static final class Companion {
        public final int getUNSPECIFIED() {
            return UNSPECIFIED;
        }

        @NotNull
        public final ArrayList<Object> getGlobalStyles() {
            return globalStyles;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

