/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.creation.validation;

import jakarta.servlet.http.HttpServletRequest;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.RequestValidator;
import me.desair.tus.server.exception.MaxUploadLengthExceededException;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.Utils;

public class UploadLengthValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws TusException {
        Long uploadLength = Utils.getLongHeader(request, "Upload-Length");
        if (uploadLength != null && uploadStorageService.getMaxUploadSize() > 0L && uploadLength > uploadStorageService.getMaxUploadSize()) {
            throw new MaxUploadLengthExceededException("Upload requests can have a maximum size of " + uploadStorageService.getMaxUploadSize());
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }
}

