/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.creation;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.exception.UploadNotFoundException;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.AbstractRequestHandler;
import me.desair.tus.server.util.TusServletRequest;
import me.desair.tus.server.util.TusServletResponse;
import me.desair.tus.server.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreationPatchRequestHandler
extends AbstractRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(CreationPatchRequestHandler.class);

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException {
        Long uploadLength;
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(servletRequest.getRequestURI(), ownerKey);
        if (uploadInfo != null && !uploadInfo.hasLength() && (uploadLength = Utils.getLongHeader((HttpServletRequest)servletRequest, "Upload-Length")) != null) {
            uploadInfo.setLength(uploadLength);
            try {
                uploadStorageService.update(uploadInfo);
            }
            catch (UploadNotFoundException e) {
                log.error("The patch request handler could not find the upload for URL " + servletRequest.getRequestURI() + ". This means something is really wrong the request validators!", (Throwable)e);
                servletResponse.sendError(500);
            }
        }
    }
}

