/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.IAdaptiveRPGroup;
import me.adaptive.arp.api.IAppContext;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.IOSType;
import me.adaptive.arp.api.LoggingBridge;

public class AppContextBridge
implements IAppContext {
    private IAdaptiveRPGroup apiGroup = IAdaptiveRPGroup.Kernel;
    private IAppContext delegate;

    public AppContextBridge(IAppContext delegate) {
        this.delegate = delegate;
    }

    public final IAppContext getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IAppContext delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getContext() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getContext...");
        }
        Object result = null;
        if (this.delegate != null) {
            result = this.delegate.getContext();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getContext' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getContext'.");
        }
        return result;
    }

    @Override
    public IOSType getContextType() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getContextType...");
        }
        IOSType result = null;
        if (this.delegate != null) {
            result = this.delegate.getContextType();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getContextType' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getContextType'.");
        }
        return result;
    }
}

