/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.models;

import com.google.gson.annotations.SerializedName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.sdk.SDKStore;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSPeerType;
import live.hms.video.sdk.models.HMSRemotePeer;
import live.hms.video.sdk.models.role.HMSRole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J5\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Llive/hms/video/sdk/models/SearchPeerResponse;", "", "peerId", "", "role", "name", "type", "Llive/hms/video/sdk/models/HMSPeerType;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Llive/hms/video/sdk/models/HMSPeerType;)V", "getPeerId", "()Ljava/lang/String;", "getRole", "getName", "getType", "()Llive/hms/video/sdk/models/HMSPeerType;", "toPeer", "Llive/hms/video/sdk/models/HMSPeer;", "store", "Llive/hms/video/sdk/SDKStore;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "lib_release"})
public final class SearchPeerResponse {
    @SerializedName(value="peer_id")
    @Nullable
    private final String peerId;
    @SerializedName(value="role")
    @NotNull
    private final String role;
    @SerializedName(value="name")
    @NotNull
    private final String name;
    @SerializedName(value="type")
    @Nullable
    private final HMSPeerType type;

    public SearchPeerResponse(@Nullable String peerId, @NotNull String role, @NotNull String name, @Nullable HMSPeerType type) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.peerId = peerId;
        this.role = role;
        this.name = name;
        this.type = type;
    }

    @Nullable
    public final String getPeerId() {
        return this.peerId;
    }

    @NotNull
    public final String getRole() {
        return this.role;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final HMSPeerType getType() {
        return this.type;
    }

    @Nullable
    public final HMSPeer toPeer(@NotNull SDKStore store) {
        HMSPeer hMSPeer;
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        if (this.peerId == null) {
            return null;
        }
        String localPeerId = store.getLocalPeerId();
        boolean isLocalPeer = Intrinsics.areEqual((Object)this.peerId, (Object)localPeerId);
        HMSRole roleType = store.getRolesMap().get(this.role);
        if (isLocalPeer) {
            hMSPeer = store.getLocalPeer();
        } else if (roleType != null) {
            HMSPeerType hMSPeerType = this.type;
            if (hMSPeerType == null) {
                hMSPeerType = HMSPeerType.REGULAR;
            }
            hMSPeer = new HMSRemotePeer(this.peerId, null, this.name, roleType, 0L, null, hMSPeerType, 32, null);
        } else {
            return null;
        }
        return hMSPeer;
    }

    @Nullable
    public final String component1() {
        return this.peerId;
    }

    @NotNull
    public final String component2() {
        return this.role;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @Nullable
    public final HMSPeerType component4() {
        return this.type;
    }

    @NotNull
    public final SearchPeerResponse copy(@Nullable String peerId, @NotNull String role, @NotNull String name, @Nullable HMSPeerType type) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new SearchPeerResponse(peerId, role, name, type);
    }

    public static /* synthetic */ SearchPeerResponse copy$default(SearchPeerResponse searchPeerResponse, String string, String string2, String string3, HMSPeerType hMSPeerType, int n, Object object) {
        if ((n & 1) != 0) {
            string = searchPeerResponse.peerId;
        }
        if ((n & 2) != 0) {
            string2 = searchPeerResponse.role;
        }
        if ((n & 4) != 0) {
            string3 = searchPeerResponse.name;
        }
        if ((n & 8) != 0) {
            hMSPeerType = searchPeerResponse.type;
        }
        return searchPeerResponse.copy(string, string2, string3, hMSPeerType);
    }

    @NotNull
    public String toString() {
        return "SearchPeerResponse(peerId=" + this.peerId + ", role=" + this.role + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ')';
    }

    public int hashCode() {
        int result2 = this.peerId == null ? 0 : this.peerId.hashCode();
        result2 = result2 * 31 + this.role.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SearchPeerResponse)) {
            return false;
        }
        SearchPeerResponse searchPeerResponse = (SearchPeerResponse)other;
        if (!Intrinsics.areEqual((Object)this.peerId, (Object)searchPeerResponse.peerId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.role, (Object)searchPeerResponse.role)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)searchPeerResponse.name)) {
            return false;
        }
        return this.type == searchPeerResponse.type;
    }
}

